/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.util;

import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class ModMath {
    public static final Vector3f CENTER_OF_ORIGIN = new Vector3f(0.5f, 0.5f, 0.5f);

    public static Vec2 rotateY(Vec2 vec, double deg) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == Vec2.f_82462_) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        double sin = Mth.m_14031_((float)angle);
        double cos = Mth.m_14089_((float)angle);
        double x = vec.f_82470_;
        double y = vec.f_82471_;
        return new Vec2((float)(x * cos + y * sin), (float)(y * cos - x * sin));
    }

    public static VoxelShape moveShape(VoxelShape shape, Vec3 vec) {
        AABB[] aabbs = (AABB[])shape.m_83299_().toArray(AABB[]::new);
        VoxelShape[] shapes = new VoxelShape[aabbs.length];
        for (int i = 0; i < aabbs.length; ++i) {
            shapes[i] = Shapes.m_83064_((AABB)ModMath.moveAABB(aabbs[i], vec));
        }
        return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])shapes);
    }

    public static AABB moveAABB(AABB aabb, Vec3 vec) {
        return new AABB(aabb.f_82288_ + vec.f_82479_, aabb.f_82289_ + vec.f_82480_, aabb.f_82290_ + vec.f_82481_, aabb.f_82291_ + vec.f_82479_, aabb.f_82292_ + vec.f_82480_, aabb.f_82293_ + vec.f_82481_);
    }

    public static VoxelShape rotateShape(VoxelShape shape, Direction.Axis axis, int degrees) {
        AABB[] aabbs = (AABB[])shape.m_83299_().toArray(AABB[]::new);
        VoxelShape[] shapes = new VoxelShape[aabbs.length];
        for (int i = 0; i < aabbs.length; ++i) {
            shapes[i] = Shapes.m_83064_((AABB)ModMath.rotateAABB(aabbs[i], axis, degrees));
        }
        return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])shapes);
    }

    public static AABB rotateAABB(AABB aabb, Direction.Axis axis, int degrees) {
        int normalizedDegrees = (degrees % 360 + 360) % 360;
        if (normalizedDegrees == 0) {
            return aabb;
        }
        double minX = aabb.f_82288_;
        double minY = aabb.f_82289_;
        double minZ = aabb.f_82290_;
        double maxX = aabb.f_82291_;
        double maxY = aabb.f_82292_;
        double maxZ = aabb.f_82293_;
        switch (axis) {
            case X: {
                switch (normalizedDegrees) {
                    case 90: {
                        return new AABB(minX, -maxZ, minY, maxX, -minZ, maxY);
                    }
                    case 180: {
                        return new AABB(minX, -maxY, -maxZ, maxX, -minY, -minZ);
                    }
                    case 270: {
                        return new AABB(minX, minZ, -maxY, maxX, maxZ, -minY);
                    }
                }
                break;
            }
            case Y: {
                switch (normalizedDegrees) {
                    case 90: {
                        return new AABB(1.0 - maxZ, minY, minX, 1.0 - minZ, maxY, maxX);
                    }
                    case 180: {
                        return new AABB(1.0 - maxX, minY, 1.0 - maxZ, 1.0 - minX, maxY, 1.0 - minZ);
                    }
                    case 270: {
                        return new AABB(minZ, minY, 1.0 - maxX, maxZ, maxY, 1.0 - minX);
                    }
                }
                break;
            }
            case Z: {
                switch (normalizedDegrees) {
                    case 90: {
                        return new AABB(-maxY, minX, minZ, -minY, maxX, maxZ);
                    }
                    case 180: {
                        return new AABB(-maxX, -maxY, minZ, -minX, -minY, maxZ);
                    }
                    case 270: {
                        return new AABB(minY, -maxX, minZ, maxY, -minX, maxZ);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Axis must be 'x', 'y', or 'z'");
            }
        }
        throw new IllegalArgumentException("Degrees must be 0, 90, 180, or 270");
    }

    public static VoxelShape scaleShape(VoxelShape shape, Direction.Axis axis, double factor, double pivot) {
        AABB[] aabbs = (AABB[])shape.m_83299_().toArray(AABB[]::new);
        VoxelShape[] shapes = new VoxelShape[aabbs.length];
        for (int i = 0; i < aabbs.length; ++i) {
            shapes[i] = Shapes.m_83064_((AABB)ModMath.scaleAABB(aabbs[i], axis, factor, pivot));
        }
        return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])shapes);
    }

    public static AABB scaleAABB(AABB aabb, Direction.Axis axis, double factor, double pivot) {
        double min;
        double max = switch (axis) {
            case Direction.Axis.X -> {
                min = aabb.f_82288_;
                yield aabb.f_82291_;
            }
            case Direction.Axis.Y -> {
                min = aabb.f_82289_;
                yield aabb.f_82292_;
            }
            case Direction.Axis.Z -> {
                min = aabb.f_82290_;
                yield aabb.f_82293_;
            }
            default -> throw new IllegalArgumentException("Axis must be 'x', 'y', or 'z'");
        };
        double minDiff = 0.5 - min;
        double maxDiff = max - 0.5;
        double newMin = 0.5 - factor * minDiff;
        double newMax = 0.5 + factor * maxDiff;
        return switch (axis) {
            case Direction.Axis.X -> new AABB(newMin, aabb.f_82289_, aabb.f_82290_, newMax, aabb.f_82292_, aabb.f_82293_);
            case Direction.Axis.Y -> new AABB(aabb.f_82288_, newMin, aabb.f_82290_, aabb.f_82291_, newMax, aabb.f_82293_);
            case Direction.Axis.Z -> new AABB(aabb.f_82288_, aabb.f_82289_, newMin, aabb.f_82291_, aabb.f_82292_, newMax);
            default -> aabb;
        };
    }

    public static VoxelShape scaleShapeOneSide(VoxelShape shape, Direction.Axis axis, double factor, Direction.AxisDirection direction) {
        AABB[] aabbs = (AABB[])shape.m_83299_().toArray(AABB[]::new);
        VoxelShape[] shapes = new VoxelShape[aabbs.length];
        for (int i = 0; i < aabbs.length; ++i) {
            shapes[i] = Shapes.m_83064_((AABB)ModMath.scaleAABBOneSide(aabbs[i], axis, factor, direction));
        }
        return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])shapes);
    }

    public static AABB scaleAABBOneSide(AABB aabb, Direction.Axis axis, double factor, Direction.AxisDirection direction) {
        double min;
        double max = switch (axis) {
            case Direction.Axis.X -> {
                min = aabb.f_82288_;
                yield aabb.f_82291_;
            }
            case Direction.Axis.Y -> {
                min = aabb.f_82289_;
                yield aabb.f_82292_;
            }
            case Direction.Axis.Z -> {
                min = aabb.f_82290_;
                yield aabb.f_82293_;
            }
            default -> throw new IllegalArgumentException("Axis must be 'x', 'y', or 'z'");
        };
        double minDiff = 0.5 - min;
        double maxDiff = max - 0.5;
        double newMin = direction == Direction.AxisDirection.NEGATIVE ? 0.5 - factor * minDiff : min;
        double newMax = direction == Direction.AxisDirection.POSITIVE ? 0.5 + factor * maxDiff : max;
        return switch (axis) {
            case Direction.Axis.X -> new AABB(newMin, aabb.f_82289_, aabb.f_82290_, newMax, aabb.f_82292_, aabb.f_82293_);
            case Direction.Axis.Y -> new AABB(aabb.f_82288_, newMin, aabb.f_82290_, aabb.f_82291_, newMax, aabb.f_82293_);
            case Direction.Axis.Z -> new AABB(aabb.f_82288_, aabb.f_82289_, newMin, aabb.f_82291_, aabb.f_82292_, newMax);
            default -> aabb;
        };
    }

    public static int checkPointPosition(Vec2 pointA, Vec2 pointB, Vec2 pointP) {
        return (int)Math.signum((pointB.f_82470_ - pointA.f_82470_) * (pointP.f_82471_ - pointA.f_82471_) - (pointB.f_82471_ - pointA.f_82471_) * (pointP.f_82470_ - pointA.f_82470_));
    }

    public static Vector3f rotateToDirection(Vector3f v, Vector3f dir) {
        Vector3f xAxis = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f direction = new Vector3f((Vector3fc)dir).normalize();
        if (xAxis.equals((Vector3fc)direction, 1.0E-6f)) {
            return new Vector3f((Vector3fc)v);
        }
        if (xAxis.equals((Vector3fc)new Vector3f((Vector3fc)direction).negate(), 1.0E-6f)) {
            Quaternionf q180 = new Quaternionf().fromAxisAngleRad(0.0f, 0.0f, 1.0f, (float)Math.PI);
            return q180.transform(new Vector3f((Vector3fc)v));
        }
        Vector3f axis = xAxis.cross((Vector3fc)direction, new Vector3f()).normalize();
        float angle = (float)Math.acos(xAxis.dot((Vector3fc)direction));
        Quaternionf rotation = new Quaternionf().fromAxisAngleRad((Vector3fc)axis, angle);
        return rotation.transform(new Vector3f((Vector3fc)v));
    }

    public static Vector3f rotate(Vector3f vec, Vector3f rotationVec) {
        return ModMath.rotate(vec, rotationVec.x, rotationVec.y, rotationVec.z);
    }

    public static Vector3f rotate(Vector3f vec, double xRot, double yRot, double zRot) {
        return ModMath.rotate(ModMath.rotate(ModMath.rotate(vec, xRot, Direction.Axis.X), yRot, Direction.Axis.Y), zRot, Direction.Axis.Z);
    }

    public static Vector3f rotateCentered(Vector3f vec, double deg, Direction.Axis axis) {
        Vector3f shift = ModMath.getCenterOf(new Vector3i());
        return ModMath.rotate(new Vector3f((Vector3fc)vec).sub((Vector3fc)shift), deg, axis).add((Vector3fc)shift);
    }

    public static Vector3f rotate(Vector3f vec, double deg, Direction.Axis axis) {
        if (deg == 0.0) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        float sin = Mth.m_14031_((float)angle);
        float cos = Mth.m_14089_((float)angle);
        float x = vec.x;
        float y = vec.y;
        float z = vec.z;
        if (axis == Direction.Axis.X) {
            return new Vector3f(x, y * cos - z * sin, z * cos + y * sin);
        }
        if (axis == Direction.Axis.Y) {
            return new Vector3f(x * cos + z * sin, y, z * cos - x * sin);
        }
        if (axis == Direction.Axis.Z) {
            return new Vector3f(x * cos - y * sin, y * cos + x * sin, z);
        }
        return vec;
    }

    public static Vector3f getCenterOf(Vector3i pos) {
        if (pos.equals((Object)new Vector3i())) {
            return CENTER_OF_ORIGIN;
        }
        return new Vector3f((Vector3ic)pos).add(0.5f, 0.5f, 0.5f);
    }

    public static Vector3f centerOf(Vector3f ... points) {
        if (points == null || points.length == 0) {
            return null;
        }
        Vector3f sum = new Vector3f(0.0f, 0.0f, 0.0f);
        for (Vector3f v : points) {
            sum.add((Vector3fc)v);
        }
        sum.div((float)points.length);
        return sum;
    }

    public static double snap(double x, double a) {
        if (a <= 0.0) {
            throw new IllegalArgumentException("a must be > 0");
        }
        return Math.floor(x / a) * a;
    }

    public static double snapNearest(double x, double a) {
        if (a <= 0.0) {
            throw new IllegalArgumentException("a must be > 0");
        }
        return (double)Math.round(x / a) * a;
    }
}

