/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.paw.util.collision;

import de.mrjulsen.paw.util.collision.ICollisionProvider;
import de.mrjulsen.paw.util.collision.RaycastHitResult;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RaycastUtils {
    public static Optional<RaycastHitResult> rayTrace(Vector3f start, Vector3f end, Level level, float radius, float stepSize, ICollisionProvider collisionProvider) {
        Vector3f direction = new Vector3f((Vector3fc)end).sub((Vector3fc)start);
        Vector3f normal = new Vector3f((Vector3fc)direction).normalize();
        Vector3f step = new Vector3f((Vector3fc)normal).mul(stepSize);
        float length = direction.length();
        Vector3f current = new Vector3f((Vector3fc)start);
        HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
        RaycastHitResult closestHit = null;
        for (float distance = 0.0f; distance < length; distance += stepSize) {
            current.add((Vector3fc)step);
            Iterator positions = BlockPos.m_121976_((int)((int)Math.floor(current.x() - radius)), (int)((int)Math.floor(current.y() - radius)), (int)((int)Math.floor(current.z() - radius)), (int)((int)Math.floor(current.x() + radius)), (int)((int)Math.floor(current.y() + radius)), (int)((int)Math.floor(current.z() + radius))).iterator();
            while (positions.hasNext()) {
                Optional<RaycastHitResult> hit;
                BlockPos pos = new BlockPos((Vec3i)positions.next());
                if (!checkedBlocks.add(pos) || !(hit = collisionProvider.tryHit(level, pos, new Vector3f((Vector3fc)start), new Vector3f((Vector3fc)normal))).isPresent() || closestHit != null && !(hit.get().getDistance() < closestHit.getDistance())) continue;
                closestHit = hit.get();
            }
            if (closestHit == null) continue;
            return Optional.of(closestHit);
        }
        return Optional.ofNullable(closestHit);
    }
}

