/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires;

import com.google.common.collect.ImmutableMap;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.wires.Wire;
import de.mrjulsen.wires.WirePoints;
import de.mrjulsen.wires.decoration.WireDecorationData;
import de.mrjulsen.wires.render.WireRenderData;
import de.mrjulsen.wires.render.WireSegmentRenderData;
import de.mrjulsen.wires.render.WireSegmentRenderDataBatch;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.core.SectionPos;

public class WireBatch {
    private final Map<String, Wire> subWires = new HashMap<String, Wire>();
    private final Cache<ImmutableMap<String, WirePoints>> collisionCache = new Cache(() -> {
        ImmutableMap.Builder points = ImmutableMap.builder();
        for (Map.Entry<String, Wire> wire : this.subWires.entrySet()) {
            if (!wire.getValue().getCollisionData().isPresent()) continue;
            points.put((Object)wire.getKey(), (Object)wire.getValue().collisionData());
        }
        return points.build();
    });
    private final Cache<ImmutableMap<String, WireRenderData>> renderCache = new Cache(() -> {
        ImmutableMap.Builder points = ImmutableMap.builder();
        for (Map.Entry<String, Wire> wire : this.subWires.entrySet()) {
            if (!wire.getValue().getRenderData().isPresent()) continue;
            points.put((Object)wire.getKey(), (Object)wire.getValue().renderData());
        }
        return points.build();
    });

    private WireBatch() {
    }

    public WireBatch(Wire mainWire) {
        this.subWires.put(mainWire.name(), mainWire);
    }

    public static WireBatch of(Wire ... wires) {
        if (wires.length <= 0) {
            return new WireBatch();
        }
        WireBatch batch = new WireBatch(wires[0]);
        for (int i = 1; i < wires.length; ++i) {
            batch.addSubWire(wires[i]);
        }
        return batch;
    }

    public Wire addSubWire(Wire subWire) {
        this.subWires.put(subWire.name(), subWire);
        return subWire;
    }

    public int count() {
        return this.subWires.size();
    }

    public boolean isEmpty() {
        return this.count() <= 0;
    }

    public Map<String, Wire> getWires() {
        return Collections.unmodifiableMap(this.subWires);
    }

    public ImmutableMap<String, WirePoints> getCollisions() {
        return (ImmutableMap)this.collisionCache.get();
    }

    public ImmutableMap<String, WireRenderData> getRenderData() {
        return (ImmutableMap)this.renderCache.get();
    }

    public Map<SectionPos, WireSegmentRenderDataBatch> splitRenderDataInChunkSections(UUID id, Collection<WireDecorationData> decorations) {
        if (this.isEmpty()) {
            return Map.of();
        }
        HashMap<SectionPos, WireSegmentRenderDataBatch> result = new HashMap<SectionPos, WireSegmentRenderDataBatch>();
        HashMap<String, TreeMap> decorationsMapped = new HashMap<String, TreeMap>();
        for (WireDecorationData wireDecorationData : decorations) {
            decorationsMapped.computeIfAbsent(wireDecorationData.getWireName(), name -> new TreeMap()).put(Float.valueOf(wireDecorationData.getPos()), wireDecorationData);
        }
        for (Map.Entry entry : this.subWires.entrySet()) {
            Wire wire = (Wire)entry.getValue();
            String wireName = (String)entry.getKey();
            TreeMap wireDecor = (TreeMap)decorationsMapped.get(wireName);
            Optional<WireRenderData> data = wire.getRenderData();
            if (!data.isPresent()) continue;
            Map<SectionPos, WireSegmentRenderData> segments = data.get().splitInChunkSections(wireDecor);
            for (Map.Entry<SectionPos, WireSegmentRenderData> segment : segments.entrySet()) {
                result.computeIfAbsent(segment.getKey(), x -> new WireSegmentRenderDataBatch(id, (SectionPos)segment.getKey())).addSegment(segment.getValue());
            }
        }
        return result;
    }
}

