/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.data.MapCache;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.paw.config.ModServerConfig;
import de.mrjulsen.wires.WirePoints;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WireCollision {
    private final UUID connectionId;
    private final Map<String, WirePoints> points;
    private final BlockPos sectionOrigin;
    private final Set<ChunkPos> chunks = new HashSet<ChunkPos>();
    private final Multimap<BlockPos, WireBlockCollision> blocks = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Set<SectionPos> sections = new HashSet<SectionPos>();
    private final MapCache<Float, String, String> lengthCache;

    public WireCollision(Multimap<ChunkPos, WireCollision> chunkMap, Multimap<SectionPos, WireCollision> sectionMap, Multimap<BlockPos, WireCollision> blockMap, UUID connectionId, BlockPos origin, Map<String, WirePoints> points) {
        chunkMap.values().removeIf(x -> x.getId().equals(connectionId));
        sectionMap.values().removeIf(x -> x.getId().equals(connectionId));
        blockMap.values().removeIf(x -> x.getId().equals(connectionId));
        this.connectionId = connectionId;
        this.sectionOrigin = SectionPos.m_123199_((BlockPos)origin).m_123249_();
        this.points = ImmutableMap.copyOf(points);
        this.lengthCache = new MapCache(name -> {
            WirePoints p = (WirePoints)points.get(name);
            float len = 0.0f;
            Vector3f a = p.vertices()[0];
            for (int i = 1; i < p.vertices().length; ++i) {
                Vector3f b = p.vertices()[i];
                len += b.distance((Vector3fc)a);
                a = b;
            }
            return Float.valueOf(len);
        }, Object::hashCode);
        for (Map.Entry<String, WirePoints> p : points.entrySet()) {
            Vector3f[] vec = p.getValue().vertices();
            Map<BlockPos, WireBlockCollision> positions = this.traceAlongWire(p.getKey(), vec, (float)(0.0625 * (Double)ModServerConfig.WIRE_COLLISION_TRACER_STEP_SIZE.get()), origin);
            for (Map.Entry<BlockPos, WireBlockCollision> pos : positions.entrySet()) {
                DLUtils.doIfNotNull(blockMap, x -> x.put((Object)((BlockPos)pos.getKey()), (Object)this));
                SectionPos section = SectionPos.m_123199_((BlockPos)pos.getKey());
                ChunkPos chunk = section.m_123251_();
                if (this.sections.add(section)) {
                    DLUtils.doIfNotNull(sectionMap, x -> x.put((Object)section, (Object)this));
                }
                if (this.chunks.add(chunk)) {
                    DLUtils.doIfNotNull(chunkMap, x -> x.put((Object)chunk, (Object)this));
                }
                this.blocks.put((Object)pos.getKey(), (Object)pos.getValue());
            }
        }
    }

    public UUID getId() {
        return this.connectionId;
    }

    public Set<BlockPos> blocksIn() {
        return Collections.unmodifiableSet(this.blocks.keySet());
    }

    public Collection<WireBlockCollision> collisionsInBlock(BlockPos pos) {
        return Collections.unmodifiableCollection(this.blocks.get((Object)pos));
    }

    public Set<SectionPos> sectionsIn() {
        return Collections.unmodifiableSet(this.sections);
    }

    public Collection<WireBlockCollision> getAllCollisions() {
        return Collections.unmodifiableCollection(this.blocks.values());
    }

    public float length(String wireName) {
        if (!this.points.containsKey(wireName)) {
            return 0.0f;
        }
        return ((Float)this.lengthCache.get((Object)wireName, (Object)wireName)).floatValue();
    }

    public WirePoints getWirePointsOf(String wireName) {
        return this.points.get(wireName);
    }

    public float worldPosToWirePos(String name, Vector3f p) {
        Vector3f[] v = this.getWirePointsOf(name).vertices();
        float nextDistSqr = Float.MAX_VALUE;
        float lenNextPoint = 0.0f;
        float sum = 0.0f;
        Vector3f a = new Vector3f((Vector3fc)v[0]).add((float)this.sectionOrigin.m_123341_(), (float)this.sectionOrigin.m_123342_(), (float)this.sectionOrigin.m_123343_());
        for (int i = 1; i < v.length; ++i) {
            Vector3f b = new Vector3f((Vector3fc)v[i]).add((float)this.sectionOrigin.m_123341_(), (float)this.sectionOrigin.m_123342_(), (float)this.sectionOrigin.m_123343_());
            Vector3f ab = new Vector3f((Vector3fc)b).sub((Vector3fc)a);
            Vector3f ap = new Vector3f((Vector3fc)p).sub((Vector3fc)a);
            float segmentLength = ab.length();
            float t = ab.dot((Vector3fc)ap) / ab.lengthSquared();
            Vector3f nextPoint = new Vector3f((Vector3fc)ab).mul(t = Math.max(0.0f, Math.min(1.0f, t))).add((Vector3fc)a);
            float distSqr = new Vector3f((Vector3fc)p).sub((Vector3fc)nextPoint).lengthSquared();
            if (distSqr < nextDistSqr) {
                nextDistSqr = distSqr;
                lenNextPoint = sum + segmentLength * t;
            }
            sum += segmentLength;
            a = b;
        }
        return lenNextPoint;
    }

    public Vector3f wirePosToWorldPos(String name, float distanceOnWire) {
        Vector3f[] v = this.getWirePointsOf(name).vertices();
        Vector3f a = new Vector3f((Vector3fc)v[0]).add((float)this.sectionOrigin.m_123341_(), (float)this.sectionOrigin.m_123342_(), (float)this.sectionOrigin.m_123343_());
        float sum = 0.0f;
        for (int i = 1; i < v.length; ++i) {
            Vector3f b = new Vector3f((Vector3fc)v[i]).add((float)this.sectionOrigin.m_123341_(), (float)this.sectionOrigin.m_123342_(), (float)this.sectionOrigin.m_123343_());
            Vector3f ab = new Vector3f((Vector3fc)b).sub((Vector3fc)a);
            float segmentLength = ab.length();
            if (distanceOnWire <= sum + segmentLength) {
                float t = (distanceOnWire - sum) / segmentLength;
                return new Vector3f((Vector3fc)ab).mul(t).add((Vector3fc)a);
            }
            sum += segmentLength;
            a = b;
        }
        return new Vector3f((Vector3fc)v[v.length - 1]).add((float)this.sectionOrigin.m_123341_(), (float)this.sectionOrigin.m_123342_(), (float)this.sectionOrigin.m_123343_());
    }

    private Map<BlockPos, WireBlockCollision> traceAlongWire(String wireName, Vector3f[] points, float step, BlockPos origin) {
        if (points.length <= 1) {
            return Map.of();
        }
        BlockPos originSection = SectionPos.m_123199_((BlockPos)origin).m_123249_();
        HashMap<BlockPos, WireBlockCollision> blocks = new HashMap<BlockPos, WireBlockCollision>();
        Vector3f prevVec = points[0];
        BlockPos lastBlock = null;
        Vector3f lastPoint = null;
        Vector3f currentPoint = null;
        for (int i = 1; i < points.length; ++i) {
            Vector3f vec = points[i];
            Vector3f delta = new Vector3f((Vector3fc)vec).sub((Vector3fc)prevVec);
            Vector3f normalized = new Vector3f((Vector3fc)delta).normalize();
            double length = delta.length();
            int c = (int)Math.ceil(length / (double)step);
            for (int k = 0; k <= c; ++k) {
                Vector3f v = new Vector3f((Vector3fc)prevVec).add((Vector3fc)new Vector3f((Vector3fc)normalized).mul((float)k * step));
                BlockPos newPos = new BlockPos((int)Math.floor(v.x), (int)Math.floor(v.y), (int)Math.floor(v.z)).m_121955_((Vec3i)originSection);
                currentPoint = new Vector3f((float)originSection.m_123341_() + v.x, (float)originSection.m_123342_() + v.y, (float)originSection.m_123343_() + v.z);
                if (lastBlock != null && lastBlock.equals((Object)newPos)) continue;
                if (lastBlock != null && lastPoint != null) {
                    BlockPos fLastPos = lastBlock;
                    Vector3f fLastPoint = lastPoint;
                    Vector3f fCurrentPoint = currentPoint;
                    blocks.computeIfAbsent(fLastPos, x -> new WireBlockCollision(this, this.getId(), wireName, fLastPos, new Vector3f((Vector3fc)fLastPoint).sub((float)fLastPos.m_123341_(), (float)fLastPos.m_123342_(), (float)fLastPos.m_123343_()))).setSecondPoint(new Vector3f((Vector3fc)fCurrentPoint).sub((float)fLastPos.m_123341_(), (float)fLastPos.m_123342_(), (float)fLastPos.m_123343_()));
                }
                lastPoint = currentPoint;
                lastBlock = newPos;
            }
            prevVec = vec;
        }
        if (lastBlock != null && lastPoint != null) {
            BlockPos fLastPos = lastBlock;
            Vector3f fLastPoint = lastPoint;
            Vector3f fCurrentPoint = currentPoint;
            blocks.computeIfAbsent(fLastPos, x -> new WireBlockCollision(this, this.getId(), wireName, fLastPos, new Vector3f((Vector3fc)fLastPoint).sub((float)fLastPos.m_123341_(), (float)fLastPos.m_123342_(), (float)fLastPos.m_123343_()))).setSecondPoint(new Vector3f(fCurrentPoint).sub((float)fLastPos.m_123341_(), (float)fLastPos.m_123342_(), (float)fLastPos.m_123343_()));
        }
        return blocks;
    }

    public static boolean connectionBlocked(Level level, BlockPos pos, BlockState state, Vector3f a, Vector3f b) {
        VoxelShape shape = state.m_60812_((BlockGetter)level, pos);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83144_(), (BooleanOp)BooleanOp.f_82689_);
        for (AABB aabb : shape.m_83299_()) {
            if (!(aabb = aabb.m_82400_(1.0E-5)).m_82390_(new Vec3(a)) && !aabb.m_82390_(new Vec3(b)) && !aabb.m_82371_(new Vec3(a), new Vec3(b)).isPresent()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WireCollision");
        for (WireBlockCollision c : this.blocks.values()) {
            sb.append("\n");
            sb.append(c.toString());
        }
        return sb.toString();
    }

    public static class WireBlockCollision {
        private final UUID id;
        private final WireCollision collision;
        private final String wireName;
        private final BlockPos pos;
        private final Vector3f entryPointA;
        private Vector3f entryPointB;
        private final Cache<Vector3f> absA;
        private final Cache<Vector3f> absB;

        public WireBlockCollision(WireCollision collision, UUID id, String wireName, BlockPos pos, Vector3f entryPointA) {
            this.id = id;
            this.collision = collision;
            this.wireName = wireName;
            this.pos = pos;
            this.entryPointA = new Vector3f(WireBlockCollision.bounds(entryPointA.x), entryPointA.y, WireBlockCollision.bounds(entryPointA.z));
            this.absA = new Cache(() -> new Vector3f((Vector3fc)this.entryPointA).add((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_()));
            this.absB = new Cache(() -> new Vector3f((Vector3fc)this.entryPointB).add((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_()));
        }

        public WireBlockCollision(WireCollision collision, UUID id, String wireName, BlockPos pos, Vector3f entryPointA, Vector3f entryPointB) {
            this(collision, id, wireName, pos, entryPointA);
            this.entryPointB = new Vector3f(WireBlockCollision.bounds(entryPointB.x), entryPointB.y, WireBlockCollision.bounds(entryPointB.z));
            this.absA.clear();
            this.absB.clear();
        }

        public UUID getId() {
            return this.id;
        }

        public WireCollision getCollision() {
            return this.collision;
        }

        public WireBlockCollision setSecondPoint(Vector3f oEntryPointB) {
            this.entryPointB = new Vector3f(WireBlockCollision.bounds(oEntryPointB.x), oEntryPointB.y, WireBlockCollision.bounds(oEntryPointB.z));
            this.absA.clear();
            this.absB.clear();
            return this;
        }

        private static float bounds(double v) {
            return (float)(v <= 0.0625 ? 0.0 : (v >= 0.9375 ? 1.0 : v));
        }

        public final String toString() {
            return String.format("%s (in: %s, out: %s)", this.pos, this.entryPointA, this.entryPointB);
        }

        public final int hashCode() {
            return Objects.hash(this.pos, this.entryPointA, this.entryPointB);
        }

        public final boolean equals(Object other) {
            if (other instanceof WireBlockCollision) {
                WireBlockCollision o = (WireBlockCollision)other;
                return this.pos.equals((Object)o.pos) && this.entryPointA.equals((Object)o.entryPointA) && this.entryPointB.equals((Object)o.entryPointB);
            }
            return false;
        }

        public BlockPos pos() {
            return this.pos;
        }

        public Vector3f entryPointA() {
            return this.entryPointA;
        }

        public Vector3f entryPointB() {
            return this.entryPointB;
        }

        public Vector3f absA() {
            return (Vector3f)this.absA.get();
        }

        public Vector3f absB() {
            return (Vector3f)this.absB.get();
        }

        public String wireName() {
            return this.wireName;
        }
    }
}

