/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires;

import com.google.common.collect.Multimap;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.wires.IWireType;
import de.mrjulsen.wires.WireCollision;
import de.mrjulsen.wires.WireTypeRegistry;
import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.block.IWireConnector;
import de.mrjulsen.wires.decoration.IWireDecoration;
import de.mrjulsen.wires.decoration.WireDecorationData;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.network.WireConnectionSyncData;
import de.mrjulsen.wires.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.joml.Vector3f;

public class WireConnection {
    private static final String NBT_ID = "Id";
    private static final String NBT_POS_A = "PosA";
    private static final String NBT_POS_B = "PosB";
    private static final String NBT_WIRE_TYPE = "WireType";
    private static final String NBT_CONNECTION_DATA_A = "CachedDataA";
    private static final String NBT_CONNECTION_DATA_B = "CachedDataB";
    private static final String NBT_CREATION_DATA = "CreationData";
    private static final String NBT_DECORATIONS = "Decorations";
    private final UUID id;
    private final BlockPos pointA;
    private final BlockPos pointB;
    private final IWireType wireType;
    private CompoundTag connectionANbt;
    private CompoundTag connectionBNbt;
    private final CompoundTag customData;
    private final Map<String, TreeMap<Float, WireDecorationData>> decorations = new HashMap<String, TreeMap<Float, WireDecorationData>>();
    private WireCollision collisionRef;
    private WireConnectionSyncData syncData;
    private final Cache<Integer> hashCache = new Cache(() -> 31 * Objects.hash(this.getPointA(), this.getPointB(), this.getConnectionANbt(), this.getConnectionBNbt(), this.getWireType().getRegistryId()) * Objects.hash(this.getPointB(), this.getPointA(), this.getConnectionBNbt(), this.getConnectionANbt(), this.getWireType().getRegistryId()));

    public WireConnection(UUID id, BlockPos pointA, BlockPos pointB, IWireType type, CompoundTag connectionANbt, CompoundTag connectionBNbt, CompoundTag customData) {
        this.id = id;
        this.pointA = pointA;
        this.pointB = pointB;
        this.wireType = type;
        this.connectionANbt = connectionANbt;
        this.connectionBNbt = connectionBNbt;
        this.customData = customData;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_(NBT_ID, this.id);
        DLUtils.putNbtBlockPos((CompoundTag)nbt, (String)NBT_POS_A, (BlockPos)this.pointA);
        DLUtils.putNbtBlockPos((CompoundTag)nbt, (String)NBT_POS_B, (BlockPos)this.pointB);
        nbt.m_128359_(NBT_WIRE_TYPE, this.wireType.getRegistryId().toString());
        nbt.m_128365_(NBT_CONNECTION_DATA_A, (Tag)this.connectionANbt);
        nbt.m_128365_(NBT_CONNECTION_DATA_B, (Tag)this.connectionBNbt);
        nbt.m_128365_(NBT_CREATION_DATA, (Tag)this.customData);
        ListTag decorationsList = new ListTag();
        for (WireDecorationData deco : this.getDecorations()) {
            decorationsList.add((Object)deco.toNbt());
        }
        nbt.m_128365_(NBT_DECORATIONS, (Tag)decorationsList);
        return nbt;
    }

    public static Optional<WireConnection> fromNbt(CompoundTag nbt) {
        ResourceLocation wireTypeId = Utils.resLoc(nbt.m_128461_(NBT_WIRE_TYPE));
        if (WireTypeRegistry.has(wireTypeId)) {
            WireConnection connection = new WireConnection(nbt.m_128342_(NBT_ID), DLUtils.getNbtBlockPos((CompoundTag)nbt, (String)NBT_POS_A), DLUtils.getNbtBlockPos((CompoundTag)nbt, (String)NBT_POS_B), WireTypeRegistry.get(wireTypeId), nbt.m_128469_(NBT_CONNECTION_DATA_A), nbt.m_128469_(NBT_CONNECTION_DATA_B), nbt.m_128469_(NBT_CREATION_DATA));
            nbt.m_128437_(NBT_DECORATIONS, 10).forEach(x -> connection.addDecoration(WireDecorationData.fromNbt((CompoundTag)x)));
            return Optional.of(connection);
        }
        return Optional.empty();
    }

    public boolean addDecoration(Vector3f pos, String wireName, IWireDecoration<?> element) {
        float d = this.collisionRef.worldPosToWirePos(wireName, pos);
        if (this.decorations.containsKey(wireName)) {
            TreeMap<Float, WireDecorationData> map = this.decorations.get(wireName);
            Map.Entry<Float, WireDecorationData> lower = map.lowerEntry(Float.valueOf(d));
            Map.Entry<Float, WireDecorationData> upper = map.ceilingEntry(Float.valueOf(d));
            if (lower != null && lower.getKey().floatValue() + lower.getValue().getDecoration().getRadius(null) > d - element.getRadius(null) || upper != null && upper.getKey().floatValue() - upper.getValue().getDecoration().getRadius(null) < d + element.getRadius(null)) {
                return false;
            }
        }
        WireDecorationData decoration = new WireDecorationData(wireName, d, element);
        this.addDecoration(decoration);
        return true;
    }

    private void addDecoration(WireDecorationData decoration) {
        this.decorations.computeIfAbsent(decoration.getWireName(), x -> new TreeMap()).put(Float.valueOf(decoration.getPos()), decoration);
    }

    public List<WireDecorationData> getDecorationsAt(Vector3f pos, String wireName) {
        float d = this.collisionRef.worldPosToWirePos(wireName, pos);
        if (!this.decorations.containsKey(wireName)) {
            return List.of();
        }
        TreeMap<Float, WireDecorationData> map = this.decorations.get(wireName);
        ArrayList<WireDecorationData> decoResult = new ArrayList<WireDecorationData>(2);
        for (WireDecorationData decoration : map.values()) {
            if (!(decoration.getPos() + decoration.getDecoration().getRadius(null) >= d) || !(decoration.getPos() - decoration.getDecoration().getRadius(null) <= d)) continue;
            decoResult.add(decoration);
        }
        return decoResult;
    }

    public void removeDecorations(Level level, Optional<Player> player, String wireName, List<WireDecorationData> decorations) {
        if (this.decorations.containsKey(wireName)) {
            TreeMap<Float, WireDecorationData> map = this.decorations.get(wireName);
            map.values().removeAll(decorations);
            for (WireDecorationData deco : decorations) {
                deco.getDecoration().onBreak(level, this.collisionRef.wirePosToWorldPos(wireName, deco.getPos()), player);
            }
            if (map.isEmpty()) {
                this.decorations.remove(wireName);
            }
        }
    }

    public boolean recalcAttachPoints(WireGraph network, Multimap<ChunkPos, WireCollision> chunkMap, Multimap<SectionPos, WireCollision> sectionMap, Multimap<BlockPos, WireCollision> blockMap) {
        Block connectorData;
        IWireConnector c;
        Block block;
        boolean hasChanged = false;
        if (network.getLevel().m_46749_(this.getPointA()) && (block = network.getLevel().m_8055_(this.getPointA()).m_60734_()) instanceof IWireConnector) {
            c = (IWireConnector)block;
            connectorData = null;
            if (!this.connectionANbt.equals((Object)connectorData)) {
                this.connectionANbt = connectorData;
                hasChanged = true;
            }
        }
        if (network.getLevel().m_46749_(this.getPointB()) && (connectorData = network.getLevel().m_8055_(this.getPointB()).m_60734_()) instanceof IWireConnector) {
            c = (IWireConnector)connectorData;
            connectorData = null;
            if (!this.connectionBNbt.equals((Object)connectorData)) {
                this.connectionBNbt = connectorData;
                hasChanged = true;
            }
        }
        if (!hasChanged) {
            return false;
        }
        WireConnectionSyncData sync = WireConnectionSyncData.of(this);
        WireCollision collision = null;
        this.setCollisionData(collision);
        this.setWireConnectionSyncData(sync);
        WiresApi.LOGGER.warn("A wire was misaligned! Data has been corrected. ID: {}, PointA: {}, PointB: {}", new Object[]{this.id, this.pointA, this.pointB});
        return true;
    }

    public Collection<WireDecorationData> getDecorations() {
        ArrayList<WireDecorationData> decorations = new ArrayList<WireDecorationData>();
        for (TreeMap<Float, WireDecorationData> decor : this.decorations.values()) {
            for (WireDecorationData d : decor.values()) {
                decorations.add(d);
            }
        }
        return decorations;
    }

    public UUID getId() {
        return this.id;
    }

    public BlockPos getPointA() {
        return this.pointA;
    }

    public BlockPos getPointB() {
        return this.pointB;
    }

    public IWireType getWireType() {
        return this.wireType;
    }

    public CompoundTag getConnectionANbt() {
        return this.connectionANbt;
    }

    public CompoundTag getConnectionBNbt() {
        return this.connectionBNbt;
    }

    public CompoundTag getCustomData() {
        return this.customData;
    }

    public void setCollisionData(WireCollision data) {
        this.collisionRef = data;
    }

    public WireCollision getCollisionData() {
        return this.collisionRef;
    }

    public void setWireConnectionSyncData(WireConnectionSyncData data) {
        this.syncData = data;
    }

    public WireConnectionSyncData getWireConnectionSyncData() {
        return this.syncData;
    }

    public SectionPos originChunkSection() {
        return SectionPos.m_123199_((BlockPos)this.pointA);
    }

    public Vector3f getRelativeStart() {
        return this.calcRelative(this.pointA);
    }

    public Vector3f getRelativeEnd() {
        return this.calcRelative(this.pointB);
    }

    public Vector3f calcRelative(BlockPos pos) {
        BlockPos sectionPos = this.originChunkSection().m_123249_();
        return new Vector3f((float)(pos.m_123341_() - sectionPos.m_123341_()), (float)(pos.m_123342_() - sectionPos.m_123342_()), (float)(pos.m_123343_() - sectionPos.m_123343_()));
    }

    public int hashCode() {
        return (Integer)this.hashCache.get();
    }

    public void onRemove(Level level, Vector3f breakPosition, Optional<Player> player) {
        for (TreeMap<Float, WireDecorationData> e : this.decorations.values()) {
            for (WireDecorationData decoration : e.values()) {
                decoration.getDecoration().onBreak(level, this.collisionRef.wirePosToWorldPos(decoration.getWireName(), decoration.getPos()), player);
            }
        }
    }
}

