/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires;

import de.mrjulsen.wires.IWireType;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public class WireTypeRegistry {
    private static final Map<ResourceLocation, IWireType> registeredTypes = new HashMap<ResourceLocation, IWireType>();

    public static <T extends IWireType> T register(String modid, String name, Function<ResourceLocation, T> type) {
        ResourceLocation location = new ResourceLocation(modid, name);
        if (registeredTypes.containsKey(location)) {
            throw new IllegalArgumentException("A wire with ID '" + location.toString() + "' is already registered.");
        }
        IWireType wire = (IWireType)type.apply(location);
        registeredTypes.put(location, wire);
        return (T)wire;
    }

    public static IWireType get(ResourceLocation id) {
        if (!WireTypeRegistry.has(id)) {
            throw new NoSuchElementException("There is no wire type with id '" + String.valueOf(id) + "' registered.");
        }
        return registeredTypes.get(id);
    }

    public static boolean has(ResourceLocation id) {
        return registeredTypes.containsKey(id);
    }
}

