/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.block;

import de.mrjulsen.mcdragonlib.block.SyncedBlockEntity;
import de.mrjulsen.wires.block.IBlockEntityExtension;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.util.NodeId;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public class WireConnectorBlockEntity
extends SyncedBlockEntity
implements IBlockEntityExtension {
    private static final String NBT_NODE_ID = "NodeId";
    private boolean wasUnloaded = false;
    private NodeId nodeId;

    public WireConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.nodeId != null) {
            tag.m_128365_(NBT_NODE_ID, (Tag)this.nodeId.toNbt());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(NBT_NODE_ID)) {
            this.nodeId = NodeId.fromNbt(tag.m_128469_(NBT_NODE_ID));
        }
    }

    public boolean wasUnloaded() {
        return this.wasUnloaded;
    }

    @Override
    public void onChunkUnloaded() {
        this.wasUnloaded = true;
    }

    @Override
    public void onBlockEntityLoad() {
        super.onLoad();
        this.wasUnloaded = false;
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.wasUnloaded() && !this.f_58857_.f_46443_ && this.nodeId != null) {
            WireGraphManager.get(this.f_58857_, this.nodeId.graphId()).removeNode(this.nodeId.id(), new Vector3f((float)this.m_58899_().m_123341_() + 0.5f, (float)this.m_58899_().m_123342_() + 0.5f, (float)this.m_58899_().m_123343_() + 0.5f), Optional.empty());
        }
        this.wasUnloaded = false;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(NodeId id) {
        this.nodeId = id;
        this.notifyUpdate();
    }
}

