/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.wires.graph.NewWireCollision;
import de.mrjulsen.wires.graph.WireEdge;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.graph.WireNode;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WireDebugRenderer {
    private static final Deque<Pair<Vector3f, Vector3f>> highlightedWires = new ConcurrentLinkedDeque<Pair<Vector3f, Vector3f>>();

    public static boolean enabled() {
        return Minecraft.m_91087_().m_91290_().m_114377_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void renderWireCollisions(PoseStack poseStack) {
        if (!WireDebugRenderer.enabled()) {
            if (!highlightedWires.isEmpty()) {
                highlightedWires.clear();
            }
            return;
        }
        Vector3f cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_252839_();
        Entity entity = Minecraft.m_91087_().f_91063_.m_109153_().m_90592_();
        ChunkPos chunkPos = entity.m_146902_();
        poseStack.m_85836_();
        poseStack.m_252880_(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        MultiBufferSource.BufferSource mbs = Minecraft.m_91087_().m_91269_().m_110104_();
        for (WireGraphClient graph : WireGraphManager.getAllClient((Level)Minecraft.m_91087_().f_91073_)) {
            void var10_14;
            Collection<WireEdge> edges;
            for (WireNode node : graph.getNodes()) {
                if (node == null || node.getPos().distance((Vector3fc)cameraPos) > 16.0f) continue;
                WireDebugRenderer.renderNameTag(poseStack, (MultiBufferSource)mbs, 0xF000F0, node.getPos(), 0.2f, List.of(TextUtils.text((String)("ID: " + node.getId().toString())), TextUtils.text((String)("Graph: " + node.getGraph().getId().id())), TextUtils.text((String)("Type: " + String.valueOf(node.getData().getRegistryType().id()))), TextUtils.text((String)("Pos: " + String.valueOf(node.getPos()))), TextUtils.text((String)("Connections: " + node.getConnections().size()))));
            }
            for (WireEdge edge : graph.getEdges()) {
                if (edge == null || !graph.hasNode(edge.getNodeAId()) || !graph.hasNode(edge.getNodeBId()) || edge.getCenterPos().distance((Vector3fc)cameraPos) > 16.0f) continue;
                WireDebugRenderer.renderNameTag(poseStack, (MultiBufferSource)mbs, 0xF000F0, graph.getNode(edge.getNodeAId()).getPos().add((Vector3fc)graph.getNode(edge.getNodeBId()).getPos()).div(2.0f), 0.2f, List.of(TextUtils.text((String)("ID: " + String.valueOf(edge.getId()))), TextUtils.text((String)("Graph: " + edge.getGraph().getId().id())), TextUtils.text((String)("Node Type[A]: " + String.valueOf(edge.getWireConnectionData().connectorA().getRegistryType().id()))).m_130940_(ChatFormatting.LIGHT_PURPLE), TextUtils.text((String)("Node Type[B]: " + String.valueOf(edge.getWireConnectionData().connectorB().getRegistryType().id()))).m_130940_(ChatFormatting.AQUA), TextUtils.text((String)("Wire Type: " + String.valueOf(edge.getType().getRegistryId())))));
                for (WireGraphClient.DebugWireData debugWireData : graph.debug_getWireDataForEdge(edge.getId())) {
                    WireDebugRenderer.renderNameTag(poseStack, (MultiBufferSource)mbs, 0xF000F0, debugWireData.centerPos(), 0.0f, List.of(TextUtils.text((String)debugWireData.name()).m_130940_(ChatFormatting.GOLD)));
                }
            }
            VertexConsumer buffer = mbs.m_6299_(RenderType.m_110504_());
            Collection<WireNode> nodes = graph.getNodes();
            Collection<WireNode> collection = nodes;
            synchronized (collection) {
                for (WireNode wireNode : nodes) {
                    if (wireNode.getPos().distance((Vector3fc)cameraPos) > 256.0f) continue;
                    WireDebugRenderer.renderDebugLine(poseStack, buffer, new Vector3f((Vector3fc)wireNode.getPos()).sub(0.25f, 0.0f, 0.0f), new Vector3f((Vector3fc)wireNode.getPos()).add(0.25f, 0.0f, 0.0f), 1.0f, 1.0f, 0.0f, 1.0f);
                    WireDebugRenderer.renderDebugLine(poseStack, buffer, new Vector3f((Vector3fc)wireNode.getPos()).sub(0.0f, 0.25f, 0.0f), new Vector3f((Vector3fc)wireNode.getPos()).add(0.0f, 0.25f, 0.0f), 1.0f, 1.0f, 0.0f, 1.0f);
                    WireDebugRenderer.renderDebugLine(poseStack, buffer, new Vector3f((Vector3fc)wireNode.getPos()).sub(0.0f, 0.0f, 0.25f), new Vector3f((Vector3fc)wireNode.getPos()).add(0.0f, 0.0f, 0.25f), 1.0f, 1.0f, 0.0f, 1.0f);
                }
            }
            Collection<WireEdge> collection2 = edges = graph.getEdges();
            synchronized (collection2) {
                for (WireEdge edge : graph.getEdges()) {
                    if (edge.getCenterPos().distance((Vector3fc)cameraPos) > 256.0f) continue;
                    WireDebugRenderer.renderDebugLineGradient(poseStack, buffer, graph.getNode(edge.getNodeAId()).getPos(), graph.getNode(edge.getNodeBId()).getPos(), 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            }
            int n = -2;
            while (var10_14 <= 2) {
                void var11_19;
                int n2 = -2;
                while (var11_19 <= 2) {
                    ChunkPos relPos = new ChunkPos(chunkPos.f_45578_ + var10_14, chunkPos.f_45579_ + var11_19);
                    for (NewWireCollision collision : graph.getCollisionsInChunk(relPos)) {
                        if (collision == null) continue;
                        for (NewWireCollision.WireBlockCollision c : collision.getAllCollisions()) {
                            WireDebugRenderer.renderDebugLine(poseStack, buffer, new Vector3f(c.getAbsoluteInVector().x(), c.getAbsoluteInVector().y() + 0.01f, c.getAbsoluteInVector().z()), new Vector3f(c.getAbsoluteOutVector().x(), c.getAbsoluteOutVector().y() + 0.01f, c.getAbsoluteOutVector().z()), 1.0f, 0.0f, 0.0f, 1.0f);
                        }
                    }
                    ++var11_19;
                }
                ++var10_14;
            }
            while (!highlightedWires.isEmpty()) {
                Pair<Vector3f, Vector3f> pair = highlightedWires.pollFirst();
                WireDebugRenderer.renderDebugLine(poseStack, buffer, new Vector3f((Vector3fc)pair.getFirst()).sub(0.0f, 0.01f, 0.0f), new Vector3f((Vector3fc)pair.getSecond()).sub(0.0f, 0.01f, 0.0f), 0.0f, 1.0f, 0.0f, 1.0f);
            }
        }
        poseStack.m_85849_();
    }

    public static void highlightWire(Vector3f a, Vector3f b) {
        if (!WireDebugRenderer.enabled()) {
            return;
        }
        highlightedWires.addLast((Pair<Vector3f, Vector3f>)Pair.of((Object)a, (Object)b));
    }

    public static void renderDebugLine(PoseStack poseStack, VertexConsumer consumer, Vector3f from, Vector3f to, float r, float g, float b, float a) {
        float dz;
        float dy;
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        float dx = to.x() - from.x();
        float length = (float)Math.sqrt(dx * dx + (dy = to.y() - from.y()) * dy + (dz = to.z() - from.z()) * dz);
        if (length > 0.0f) {
            dx /= length;
            dy /= length;
            dz /= length;
        }
        consumer.m_252986_(matrix4f, from.x(), from.y(), from.z()).m_85950_(r, g, b, a).m_252939_(matrix3f, dx, dy, dz).m_5752_();
        consumer.m_252986_(matrix4f, to.x(), to.y(), to.z()).m_85950_(r, g, b, a).m_252939_(matrix3f, dx, dy, dz).m_5752_();
    }

    public static void renderDebugLineGradient(PoseStack poseStack, VertexConsumer consumer, Vector3f from, Vector3f to, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
        float dz;
        float dy;
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        float dx = to.x() - from.x();
        float length = (float)Math.sqrt(dx * dx + (dy = to.y() - from.y()) * dy + (dz = to.z() - from.z()) * dz);
        if (length > 0.0f) {
            dx /= length;
            dy /= length;
            dz /= length;
        }
        consumer.m_252986_(matrix4f, from.x(), from.y(), from.z()).m_85950_(r1, g1, b1, a1).m_252939_(matrix3f, dx, dy, dz).m_5752_();
        consumer.m_252986_(matrix4f, to.x(), to.y(), to.z()).m_85950_(r2, g2, b2, a2).m_252939_(matrix3f, dx, dy, dz).m_5752_();
    }

    protected static void renderNameTag(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Vector3f pos, float yOffset, List<Component> text) {
        if (Minecraft.m_91087_().m_91288_().m_20182_().m_252839_().distance((Vector3fc)pos) > 64.0f) {
            return;
        }
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        float lineHeight = 9.0f * 1.5f;
        poseStack.m_85836_();
        poseStack.m_252880_(pos.x(), pos.y() + yOffset, pos.z());
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        poseStack.m_85841_(-0.0125f, -0.0125f, 0.0125f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        for (int k = 0; k < text.size(); ++k) {
            float y = lineHeight * (float)k;
            Component txt = text.get(k);
            float opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int backgroundColor = (int)(opacity * 255.0f) << 24;
            Font font = Minecraft.m_91087_().f_91062_;
            float x = -font.m_92852_((FormattedText)txt) / 2;
            font.m_272077_(txt, x, -(lineHeight * (float)text.size()) + y, 0x20FFFFFF, false, matrix4f, buffer, Font.DisplayMode.SEE_THROUGH, backgroundColor, packedLight);
            font.m_272077_(txt, x, -(lineHeight * (float)text.size()) + y, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        }
        poseStack.m_85849_();
    }
}

