/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.decoration;

import de.mrjulsen.paw.registry.ModWireRegistry;
import de.mrjulsen.wires.decoration.IWireDecoration;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class WireDecorationData
implements Comparable<WireDecorationData> {
    private static final String NBT_WIRE_NAME = "WireName";
    private static final String NBT_POS = "Pos";
    private static final String NBT_DATA = "Data";
    private final String wireName;
    private final float wirePos;
    private final IWireDecoration<?> decoration;

    public WireDecorationData(String wireName, float wirePos, IWireDecoration<?> decoration) {
        this.wireName = wireName;
        this.wirePos = wirePos;
        this.decoration = decoration;
    }

    public String getWireName() {
        return this.wireName;
    }

    public float getPos() {
        return this.wirePos;
    }

    public IWireDecoration<?> getDecoration() {
        return this.decoration;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(NBT_WIRE_NAME, this.wireName);
        nbt.m_128350_(NBT_POS, this.wirePos);
        CompoundTag decorationNbt = this.decoration.getRegistryType().wrap(this.decoration);
        nbt.m_128365_(NBT_DATA, (Tag)decorationNbt);
        return nbt;
    }

    public static WireDecorationData fromNbt(CompoundTag nbt) {
        IWireDecoration<?> decoration = ModWireRegistry.DECORATION_REGISTRY.load(nbt.m_128469_(NBT_DATA));
        return new WireDecorationData(nbt.m_128461_(NBT_WIRE_NAME), nbt.m_128457_(NBT_POS), decoration);
    }

    @Override
    public int compareTo(WireDecorationData o) {
        return Float.compare(this.wirePos, o.wirePos);
    }
}

