/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph;

import de.mrjulsen.wires.IWireType;
import de.mrjulsen.wires.WireTypeRegistry;
import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.decoration.IWireDecoration;
import de.mrjulsen.wires.decoration.WireDecorationData;
import de.mrjulsen.wires.graph.IWireGraph;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.WireConnectionData;
import de.mrjulsen.wires.graph.data.WireEdgeHash;
import de.mrjulsen.wires.graph.data.accessor.GenericWireNodeAccessor;
import de.mrjulsen.wires.graph.data.accessor.NodeAccessor;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.graph.registry.NodeDataRegistryObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WireEdge {
    protected static final String NBT_ID = "Id";
    protected static final String NBT_WIRE_TYPE = "WireType";
    protected static final String NBT_CUSTOM_DATA = "EdgeData";
    protected static final String NBT_NODE_A = "NodeA";
    protected static final String NBT_NODE_B = "NodeB";
    protected static final String NBT_DECORATIONS = "Decorations";
    private final IWireGraph graph;
    private final UUID id;
    private WireConnectionData customData;
    private final IWireType wireType;
    private UUID nodeA;
    private UUID nodeB;
    private final WireEdgeHash hash;
    private final Map<String, TreeMap<Float, WireDecorationData>> decorations = new HashMap<String, TreeMap<Float, WireDecorationData>>();

    public WireEdge(WireGraph graph, IWireType type, WireConnectionData customData, UUID nodeA, UUID nodeB, WireEdgeHash hash) {
        this(graph, graph.createNewEdgeId(), type, customData, nodeA, nodeB, hash);
    }

    private WireEdge(IWireGraph graph, UUID id, IWireType type, WireConnectionData customData, UUID nodeA, UUID nodeB, WireEdgeHash hash) {
        this.graph = graph;
        this.id = id;
        this.wireType = type;
        this.nodeA = nodeA;
        this.nodeB = nodeB;
        this.customData = customData;
        this.hash = hash;
    }

    void swapNodes(UUID nodeA, UUID nodeB) {
        this.nodeA = nodeA;
        this.nodeB = nodeB;
    }

    public WireEdgeHash getHash() {
        return this.hash;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(NBT_WIRE_TYPE, this.wireType.getRegistryId().toString());
        nbt.m_128362_(NBT_ID, this.id);
        nbt.m_128362_(NBT_NODE_A, this.nodeA);
        nbt.m_128362_(NBT_NODE_B, this.nodeB);
        nbt.m_128365_(NBT_CUSTOM_DATA, (Tag)this.customData.toNbt());
        ListTag decorationsList = new ListTag();
        for (WireDecorationData deco : this.getDecorations()) {
            decorationsList.add((Object)deco.toNbt());
        }
        nbt.m_128365_(NBT_DECORATIONS, (Tag)decorationsList);
        return nbt;
    }

    public static Optional<WireEdge> fromNbt(IWireGraph graph, CompoundTag nbt) {
        boolean isClient = graph instanceof WireGraphClient;
        try {
            UUID nodeAId = nbt.m_128342_(NBT_NODE_A);
            UUID nodeBId = nbt.m_128342_(NBT_NODE_B);
            if (!graph.hasNode(nodeAId) || !graph.hasNode(nodeBId)) {
                throw new IllegalStateException("One of the wire connection nodes no longer exists.");
            }
            WireConnectionData customData = WireConnectionData.fromNbt(nbt.m_128469_(NBT_CUSTOM_DATA));
            WireEdgeHash hash = new WireEdgeHash(customData.customData(), graph.getNode(nodeAId), graph.getNode(nodeBId));
            if (!isClient && ((WireGraph)graph).hasEdge(hash)) {
                throw new IllegalStateException("An equivalent edge with the same data already exists. This edge is skipped.");
            }
            WireEdge edge = new WireEdge(graph, nbt.m_128342_(NBT_ID), WireTypeRegistry.get(new ResourceLocation(nbt.m_128461_(NBT_WIRE_TYPE))), customData, nodeAId, nodeBId, hash);
            nbt.m_128437_(NBT_DECORATIONS, 10).forEach(x -> edge.addDecoration(WireDecorationData.fromNbt((CompoundTag)x)));
            return Optional.of(edge);
        }
        catch (Exception e) {
            WiresApi.LOGGER.error("Could not load wire connection, because the nbt data is invalid: " + e.getMessage());
            return Optional.empty();
        }
    }

    public boolean addDecoration(Vector3f pos, String wireName, IWireDecoration<?> element) {
        IWireGraph iWireGraph = this.getGraph();
        if (!(iWireGraph instanceof WireGraph)) {
            return false;
        }
        WireGraph graph = (WireGraph)iWireGraph;
        float d = graph.getCollisionById(this.id).map(x -> Float.valueOf(x.worldPosToWirePos(wireName, pos))).orElse(Float.valueOf(0.0f)).floatValue();
        return this.addDecoration(d, wireName, element);
    }

    public boolean addDecoration(float posOnWire, String wireName, IWireDecoration<?> element) {
        IWireGraph iWireGraph = this.getGraph();
        if (!(iWireGraph instanceof WireGraph)) {
            return false;
        }
        WireGraph graph = (WireGraph)iWireGraph;
        if (!this.canPlaceDecoration(posOnWire, wireName, element)) {
            return false;
        }
        WireDecorationData decoration = new WireDecorationData(wireName, posOnWire, element);
        this.addDecoration(decoration);
        graph.sendEdgeToClient(this, true);
        return true;
    }

    public boolean canPlaceDecoration(float posOnWire, String wireName, IWireDecoration<?> element) {
        return !this.isOccupied(posOnWire, wireName, element.getRadius(element));
    }

    public boolean isOccupied(float posOnWire, String wireName, float radius) {
        if (this.decorations.containsKey(wireName)) {
            TreeMap<Float, WireDecorationData> map = this.decorations.get(wireName);
            Map.Entry<Float, WireDecorationData> lower = map.lowerEntry(Float.valueOf(posOnWire));
            Map.Entry<Float, WireDecorationData> upper = map.ceilingEntry(Float.valueOf(posOnWire));
            if (lower != null && lower.getKey().floatValue() + lower.getValue().getDecoration().getRadius(null) > posOnWire - radius || upper != null && upper.getKey().floatValue() - upper.getValue().getDecoration().getRadius(null) < posOnWire + radius) {
                return true;
            }
        }
        return false;
    }

    private void addDecoration(WireDecorationData decoration) {
        this.decorations.computeIfAbsent(decoration.getWireName(), x -> new TreeMap()).put(Float.valueOf(decoration.getPos()), decoration);
        IWireGraph iWireGraph = this.getGraph();
        if (iWireGraph instanceof WireGraph) {
            WireGraph graph = (WireGraph)iWireGraph;
            graph.m_77762_();
        }
    }

    public List<WireDecorationData> getDecorationsAt(Vector3f pos, String wireName) {
        IWireGraph iWireGraph = this.getGraph();
        if (!(iWireGraph instanceof WireGraph)) {
            return List.of();
        }
        WireGraph graph = (WireGraph)iWireGraph;
        float d = graph.getCollisionById(this.id).map(x -> Float.valueOf(x.worldPosToWirePos(wireName, pos))).orElse(Float.valueOf(0.0f)).floatValue();
        if (!this.decorations.containsKey(wireName)) {
            return List.of();
        }
        TreeMap<Float, WireDecorationData> map = this.decorations.get(wireName);
        ArrayList<WireDecorationData> decoResult = new ArrayList<WireDecorationData>(2);
        for (WireDecorationData decoration : map.values()) {
            if (!(decoration.getPos() + decoration.getDecoration().getRadius(null) >= d) || !(decoration.getPos() - decoration.getDecoration().getRadius(null) <= d)) continue;
            decoResult.add(decoration);
        }
        return decoResult;
    }

    public void removeDecorations(Level level, Optional<Player> player, String wireName, List<WireDecorationData> decorations) {
        IWireGraph iWireGraph = this.getGraph();
        if (!(iWireGraph instanceof WireGraph)) {
            return;
        }
        WireGraph graph = (WireGraph)iWireGraph;
        if (this.decorations.containsKey(wireName)) {
            TreeMap<Float, WireDecorationData> map = this.decorations.get(wireName);
            map.values().removeAll(decorations);
            for (WireDecorationData deco : decorations) {
                deco.getDecoration().onBreak(level, graph.getCollisionById(this.id).map(x -> x.wirePosToWorldPos(wireName, deco.getPos())).orElse(new Vector3f()), player);
            }
            if (map.isEmpty()) {
                this.decorations.remove(wireName);
            }
        }
        graph.m_77762_();
    }

    public Collection<WireDecorationData> getDecorations() {
        return this.getDecorations(d -> true);
    }

    public Collection<WireDecorationData> getDecorations(Predicate<WireDecorationData> condition) {
        ArrayList<WireDecorationData> decorations = new ArrayList<WireDecorationData>();
        for (TreeMap<Float, WireDecorationData> decor : this.decorations.values()) {
            for (WireDecorationData d : decor.values()) {
                if (!condition.test(d)) continue;
                decorations.add(d);
            }
        }
        return decorations;
    }

    public void queryDecorations(Predicate<WireDecorationData> condition, Consumer<WireDecorationData> callback) {
        for (TreeMap<Float, WireDecorationData> decor : this.decorations.values()) {
            for (WireDecorationData d : decor.values()) {
                if (!condition.test(d)) continue;
                callback.accept(d);
            }
        }
    }

    public void onRemove(Level level, Vector3f breakPosition, Optional<Player> player) {
        IWireGraph iWireGraph = this.getGraph();
        if (iWireGraph instanceof WireGraph) {
            WireGraph graph = (WireGraph)iWireGraph;
            for (TreeMap treeMap : this.decorations.values()) {
                for (WireDecorationData decoration : treeMap.values()) {
                    decoration.getDecoration().onBreak(level, graph.getCollisionById(this.id).map(x -> x.wirePosToWorldPos(decoration.getWireName(), decoration.getPos())).orElse(breakPosition), player);
                }
            }
            for (NodeDataRegistryObject<NodeData, NodeAccessor<?>> nodeDataRegistryObject : WiresApi.NODE_DATA_REGISTRY.getRegisteredTypes()) {
                NodeAccessor<?> nodeAccessor;
                Optional<NodeAccessor<?>> accessor = nodeDataRegistryObject.getAccessor(graph);
                if (!accessor.isPresent() || !((nodeAccessor = accessor.get()) instanceof GenericWireNodeAccessor)) continue;
                GenericWireNodeAccessor a = (GenericWireNodeAccessor)nodeAccessor;
                ArrayList<WireNode> nodes = new ArrayList<WireNode>(a.get(this.id));
                for (WireNode node : nodes) {
                    graph.removeNode(node.getId(), breakPosition, player);
                    a.remove(node);
                }
            }
        }
        this.wireType.onBreak(level, breakPosition, player, this.getGraph(), this);
    }

    public Vector3f getCenterPos() {
        List<Vector3f> vectors = List.of(this.graph.getNode(this.getNodeAId()).getPos(), this.graph.getNode(this.getNodeBId()).getPos());
        if (vectors == null || vectors.isEmpty()) {
            return null;
        }
        Vector3f summe = new Vector3f(0.0f, 0.0f, 0.0f);
        for (Vector3f v : vectors) {
            summe.add((Vector3fc)v);
        }
        return summe.div((float)vectors.size());
    }

    public int length() {
        return (int)this.graph.getNode(this.getNodeAId()).getPos().distance((Vector3fc)this.graph.getNode(this.getNodeBId()).getPos());
    }

    public IWireGraph getGraph() {
        return this.graph;
    }

    public UUID getId() {
        return this.id;
    }

    public IWireType getType() {
        return this.wireType;
    }

    public UUID getNodeAId() {
        return this.nodeA;
    }

    public UUID getNodeBId() {
        return this.nodeB;
    }

    public WireConnectionData getWireConnectionData() {
        return this.customData;
    }

    public void setWireConnectionData(WireConnectionData data) {
        this.customData = data;
    }
}

