/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.mrjulsen.paw.PantographsAndWires;
import de.mrjulsen.paw.config.ModCommonConfig;
import de.mrjulsen.paw.config.ModServerConfig;
import de.mrjulsen.paw.item.PAWWireType;
import de.mrjulsen.paw.registry.ModWireRegistry;
import de.mrjulsen.wires.IWireType;
import de.mrjulsen.wires.WireBatch;
import de.mrjulsen.wires.WireCreationContext;
import de.mrjulsen.wires.WirePoints;
import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.graph.DLStatistics;
import de.mrjulsen.wires.graph.IWireGraph;
import de.mrjulsen.wires.graph.NewWireCollision;
import de.mrjulsen.wires.graph.WireEdge;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.WireConnectionData;
import de.mrjulsen.wires.graph.data.WireEdgeHash;
import de.mrjulsen.wires.graph.data.accessor.NodeAccessor;
import de.mrjulsen.wires.graph.data.node.BlockConnectorNodeData;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.graph.data.provider.ConnectorDataProvider;
import de.mrjulsen.wires.item.CustomData;
import de.mrjulsen.wires.network.DeleteWireSyncData;
import de.mrjulsen.wires.network.WireChunkUnloadingData;
import de.mrjulsen.wires.network.WiresSyncData;
import de.mrjulsen.wires.network.packets.stc.DeleteWireConnectionPacket;
import de.mrjulsen.wires.network.packets.stc.WireConnectionChunkUnloadingPacket;
import de.mrjulsen.wires.network.packets.stc.WireConnectorDataPacket;
import de.mrjulsen.wires.util.GraphId;
import de.mrjulsen.wires.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Vector3f;

public class WireGraph
extends SavedData
implements IWireGraph {
    public static final int VERSION = 3;
    private static final String NBT_VERSION = "Version";
    private static final String NBT_NODES = "Nodes";
    private static final String NBT_EDGES = "Edges";
    private final GraphId id;
    private final Level level;
    private final Map<UUID, WireNode> nodes = new HashMap<UUID, WireNode>();
    private final Map<UUID, WireEdge> edges = new HashMap<UUID, WireEdge>();
    final Multimap<BlockPos, UUID> nodesByBlock = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    final Multimap<SectionPos, UUID> nodesBySection = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    final Multimap<ChunkPos, UUID> nodesByChunk = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    final Map<ResourceLocation, NodeAccessor<?>> nodesByType = new ConcurrentHashMap();
    final Multimap<WireNode, WireEdge> edgesByNode = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    final Map<WireEdgeHash, WireEdge> edgesByHash = new ConcurrentHashMap<WireEdgeHash, WireEdge>();
    final Map<UUID, NewWireCollision> collisionById = new ConcurrentHashMap<UUID, NewWireCollision>();
    final Multimap<BlockPos, NewWireCollision> collisionByBlock = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    final Multimap<ChunkPos, NewWireCollision> collisionByChunk = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    final Multimap<SectionPos, NewWireCollision> collisionBySection = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    private final Multimap<ChunkPos, UUID> playersWatchingChunk = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);

    public WireGraph(GraphId id, Level level) {
        this.id = id;
        this.level = level;
    }

    @Override
    public DLStatistics getStatistics() {
        DLStatistics.Group nodesGroup = new DLStatistics.Group("nodes", "N");
        DLStatistics.Group edgesGroup = new DLStatistics.Group("edges", "E");
        DLStatistics.Group collisionsGroup = new DLStatistics.Group("collisions", "C");
        DLStatistics.Group playersGroup = new DLStatistics.Group("players", "P");
        return new DLStatistics("Wires[S]", List.of(new DLStatistics.Stat(nodesGroup, NBT_NODES, this.nodes.size()), new DLStatistics.Stat(nodesGroup, "Nodes (by block)", this.nodesByBlock.size()), new DLStatistics.Stat(nodesGroup, "Nodes (by section)", this.nodesBySection.size()), new DLStatistics.Stat(nodesGroup, "Nodes (by chunk)", this.nodesByChunk.size()), new DLStatistics.Stat(edgesGroup, NBT_EDGES, this.edges.size()), new DLStatistics.Stat(edgesGroup, "Edges (by node)", this.edgesByNode.size()), new DLStatistics.Stat(edgesGroup, "Edges (by hash)", this.edgesByHash.size()), new DLStatistics.Stat(collisionsGroup, "Collision", this.collisionById.size()), new DLStatistics.Stat(collisionsGroup, "Collision (by block)", this.collisionByBlock.size()), new DLStatistics.Stat(collisionsGroup, "Collision (by section)", this.collisionBySection.size()), new DLStatistics.Stat(collisionsGroup, "Collision (by chunk)", this.collisionByChunk.size()), new DLStatistics.Stat(playersGroup, "Players Watching Chunks", this.playersWatchingChunk.size())));
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag nodes = new ListTag();
        for (WireNode node : this.nodes.values()) {
            nodes.add((Object)node.toNbt());
        }
        ListTag edges = new ListTag();
        for (WireEdge edge : this.edges.values()) {
            edges.add((Object)edge.toNbt());
        }
        nbt.m_128365_(NBT_NODES, (Tag)nodes);
        nbt.m_128365_(NBT_EDGES, (Tag)edges);
        nbt.m_128405_(NBT_VERSION, 3);
        return nbt;
    }

    public WireGraph load(ServerLevel level, CompoundTag nbt) {
        this.applyData(nbt);
        return this;
    }

    private void applyData(CompoundTag nbt) {
        for (Tag tag : nbt.m_128437_(NBT_NODES, 10)) {
            WireNode.fromNbt(this, (CompoundTag)tag).ifPresent(this::setNode);
        }
        for (Tag tag : nbt.m_128437_(NBT_EDGES, 10)) {
            WireEdge.fromNbt(this, (CompoundTag)tag).ifPresent(e -> this.setAndUpdateEdge((WireEdge)e, false));
        }
        this.m_77762_();
    }

    public String getFileId() {
        return this.getId().id() + "_wire_graph";
    }

    @Override
    public GraphId getId() {
        return this.id;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public <A extends NodeAccessor<?>> Optional<A> accessNodesOfType(ResourceLocation typeId) {
        return Optional.ofNullable(this.nodesByType.containsKey(typeId) ? this.nodesByType.get(typeId) : null);
    }

    public UUID createNewNodeId() {
        UUID id;
        while (this.nodes.containsKey(id = UUID.randomUUID())) {
        }
        return id;
    }

    public UUID createNewEdgeId() {
        UUID id;
        while (this.edges.containsKey(id = UUID.randomUUID())) {
        }
        return id;
    }

    @Override
    public WireNode getNode(UUID id) {
        return this.nodes.get(id);
    }

    @Override
    public WireEdge getEdge(UUID id) {
        return this.edges.get(id);
    }

    public WireEdge getEdge(WireEdgeHash hash) {
        return this.edgesByHash.get(hash);
    }

    @Override
    public Collection<WireNode> getNodes() {
        return Collections.synchronizedCollection(Collections.unmodifiableCollection(this.nodes.values()));
    }

    @Override
    public Collection<WireEdge> getEdges() {
        return Collections.synchronizedCollection(Collections.unmodifiableCollection(this.edges.values()));
    }

    @Override
    public boolean hasEdge(UUID id) {
        return this.edges.containsKey(id);
    }

    @Override
    public boolean hasNode(UUID id) {
        return this.nodes.containsKey(id);
    }

    public boolean hasEdge(WireEdgeHash hash) {
        return this.edgesByHash.containsKey(hash);
    }

    public WireNode createNode(NodeData data, Vector3f pos) {
        WireNode node = new WireNode(this, data);
        node.setPos(pos);
        this.setNode(node);
        return node;
    }

    private void setNode(WireNode node) {
        BlockPos blockPos = new BlockPos((int)node.getPos().x(), (int)node.getPos().y(), (int)node.getPos().z());
        SectionPos section = SectionPos.m_123199_((BlockPos)blockPos);
        ChunkPos chunk = new ChunkPos(blockPos);
        this.nodes.put(node.getId(), node);
        this.nodesByBlock.put((Object)blockPos, (Object)node.getId());
        this.nodesBySection.put((Object)section, (Object)node.getId());
        this.nodesByChunk.put((Object)chunk, (Object)node.getId());
        this.nodesByType.computeIfAbsent(node.getData().getRegistryType().id(), a -> node.getData().getRegistryType().createAccessor()).put(node);
        this.m_77762_();
    }

    public void removeNode(UUID id, Vector3f breakPos, Optional<Player> player) {
        if (!this.nodes.containsKey(id)) {
            return;
        }
        WireNode node = this.nodes.get(id);
        if (breakPos != null && player != null) {
            ArrayList edgesToRemove = new ArrayList(this.edgesByNode.get((Object)node));
            for (WireEdge edge : edgesToRemove) {
                this.removeEdge(edge.getId(), breakPos, player);
            }
            node.onRemove(this.getLevel(), breakPos, player);
        }
        this.nodes.remove(id);
        Predicate<UUID> nodeIdTest = x -> x.equals(id);
        this.nodesByBlock.values().removeIf(nodeIdTest);
        this.nodesByChunk.values().removeIf(nodeIdTest);
        this.nodesBySection.values().removeIf(nodeIdTest);
        this.nodesByType.get(node.getData().getRegistryType().id()).remove(node);
        this.m_77762_();
    }

    public CreateEdgeResult createEdge(IWireType type, CustomData customData, NodeData nodeDataA, NodeData nodeDataB, MutableInt pointStartIndex, boolean sendToPlayers) {
        WireEdgeHash hash = new WireEdgeHash(customData, nodeDataA, nodeDataB);
        if (this.edgesByHash.containsKey(hash)) {
            return new CreateEdgeResult(false, 0, Optional.empty());
        }
        WireNode nodeA = nodeDataA.getOrCreateNodeInternal(this, type, customData);
        WireNode nodeB = nodeDataB.getOrCreateNodeInternal(this, type, customData);
        if (nodeA == null || nodeB == null) {
            return new CreateEdgeResult(false, 1, Optional.empty());
        }
        Optional<ConnectorDataProvider> connectorDataA = nodeDataA.getConnectorCustomData(this, customData, nodeA, pointStartIndex.getAndIncrement());
        Optional<ConnectorDataProvider> connectorDataB = nodeDataB.getConnectorCustomData(this, customData, nodeB, pointStartIndex.getAndIncrement());
        if (sendToPlayers && (connectorDataA.isEmpty() || connectorDataB.isEmpty())) {
            return new CreateEdgeResult(false, 1, Optional.empty());
        }
        WireConnectionData custom = new WireConnectionData(customData, connectorDataA.orElse(new ConnectorDataProvider.Empty()), connectorDataB.orElse(new ConnectorDataProvider.Empty()));
        WireEdge edge = new WireEdge(this, type, custom, nodeA.getId(), nodeB.getId(), hash);
        this.setAndUpdateEdge(edge, sendToPlayers);
        return new CreateEdgeResult(true, -1, Optional.of(edge));
    }

    public void setAndUpdateEdge(WireEdge edge, boolean notifyClients) {
        this.removeEdgeInternal(edge.getId(), false);
        WireNode nodeA = this.getNode(edge.getNodeAId());
        WireNode nodeB = this.getNode(edge.getNodeBId());
        this.edges.put(edge.getId(), edge);
        this.edgesByHash.put(edge.getHash(), edge);
        this.edgesByNode.put((Object)nodeA, (Object)edge);
        this.edgesByNode.put((Object)nodeB, (Object)edge);
        nodeA.addConnection(edge.getId());
        nodeB.addConnection(edge.getId());
        this.m_77762_();
        this.updateEdge(edge, notifyClients);
    }

    public void updateEdge(WireEdge edge, boolean notifyClients) {
        this.removeEdgeCollisionInternal(edge.getId());
        WireBatch batch = edge.getType().buildWire(WireCreationContext.COLLISION, (BlockAndTintGetter)this.getLevel(), edge.getWireConnectionData(), edge, this.getNode(edge.getNodeAId()), this.getNode(edge.getNodeBId()));
        if (batch == null) {
            return;
        }
        NewWireCollision collision = new NewWireCollision(this, edge.getId(), (Map<String, WirePoints>)batch.getCollisions());
        this.collisionById.put(edge.getId(), collision);
        for (BlockPos blockPos : collision.blocksIn()) {
            this.collisionByBlock.put((Object)blockPos, (Object)collision);
        }
        for (SectionPos sectionPos : collision.sectionsIn()) {
            this.collisionBySection.put((Object)sectionPos, (Object)collision);
        }
        for (ChunkPos chunkPos : collision.chunksIn()) {
            this.collisionByChunk.put((Object)chunkPos, (Object)collision);
        }
        if (notifyClients) {
            this.sendEdgeToClient(edge, true);
        }
    }

    public void sendEdgeToClient(WireEdge edge, boolean force) {
        WireNode nodeA = this.getNode(edge.getNodeAId());
        WireNode nodeB = this.getNode(edge.getNodeBId());
        WiresSyncData netData = new WiresSyncData(this.getId(), null, () -> List.of(edge), () -> List.of(nodeA, nodeB), force);
        for (ServerPlayer player : this.getPlayersForEdge(edge.getId())) {
            WiresApi.net().CHANNEL.sendToPlayer(player, (Object)new WireConnectorDataPacket(new WiresSyncData.Wrapper(netData)));
        }
    }

    public void removeEdge(UUID id, Vector3f removePosition, Optional<Player> player) {
        if (!this.edges.containsKey(id)) {
            return;
        }
        for (ServerPlayer serverPlayer : this.getPlayersForEdge(id)) {
            WiresApi.net().CHANNEL.sendToPlayer(serverPlayer, (Object)new DeleteWireConnectionPacket(new DeleteWireSyncData(this.getId(), List.of(id))));
        }
        if (removePosition != null && player != null) {
            this.edges.get(id).onRemove(this.level, removePosition, player);
        }
        this.removeEdgeInternal(id, true);
        this.m_77762_();
    }

    protected Optional<WireEdge> removeEdgeInternal(UUID id, boolean deleteEmptyNodes) {
        WireEdge edge = this.edges.remove(id);
        if (edge == null) {
            return Optional.empty();
        }
        this.removeEdgeCollisionInternal(id);
        Predicate<WireEdge> edgeTest = x -> x.getId().equals(edge.getId());
        this.edgesByNode.values().removeIf(edgeTest);
        this.edgesByHash.values().removeIf(edgeTest);
        this.removeEdgeFromNode(edge, edge.getNodeAId(), deleteEmptyNodes);
        this.removeEdgeFromNode(edge, edge.getNodeBId(), deleteEmptyNodes);
        return Optional.of(edge);
    }

    protected void removeEdgeCollisionInternal(UUID id) {
        NewWireCollision collision = this.collisionById.remove(id);
        if (collision == null) {
            return;
        }
        Predicate<NewWireCollision> collisionTest = x -> x == collision;
        this.collisionByChunk.values().removeIf(collisionTest);
        this.collisionBySection.values().removeIf(collisionTest);
        this.collisionByBlock.values().removeIf(collisionTest);
    }

    protected void removeEdgeFromNode(WireEdge edge, UUID nodeId, boolean deleteEmptyNode) {
        if (!edge.getNodeAId().equals(nodeId) && !edge.getNodeBId().equals(nodeId)) {
            throw new IllegalStateException("Node " + String.valueOf(nodeId) + " is not part of edge " + String.valueOf(edge.getId()));
        }
        if (!this.getNode(nodeId).removeConnection(edge.getId()) && deleteEmptyNode) {
            if (((Boolean)ModCommonConfig.WIRE_CONVERTER_LOGGING.get()).booleanValue()) {
                PantographsAndWires.LOGGER.info("[GRAPH CONVERTER/UPDATER]                - REMOVE REPLACED NODE: " + String.valueOf(nodeId));
            }
            this.removeNode(nodeId, null, null);
        }
    }

    protected void replaceNodeInEdge(WireEdge edge, UUID oldNodeId, UUID newNodeId, boolean deleteEmptyNode) {
        boolean isA = edge.getNodeAId().equals(oldNodeId);
        this.removeEdgeFromNode(edge, oldNodeId, deleteEmptyNode);
        if (isA) {
            edge.swapNodes(newNodeId, edge.getNodeBId());
        } else {
            edge.swapNodes(edge.getNodeAId(), newNodeId);
        }
        if (((Boolean)ModCommonConfig.WIRE_CONVERTER_LOGGING.get()).booleanValue()) {
            PantographsAndWires.LOGGER.info("[GRAPH CONVERTER/UPDATER]            - EDGE NODES MODIFIED: " + String.valueOf(oldNodeId) + " -> " + String.valueOf(newNodeId) + ", is point A? " + isA + ", Edge Id: " + String.valueOf(edge.getId()));
        }
    }

    public Collection<ServerPlayer> getPlayersForEdge(UUID edgeId) {
        if (!this.collisionById.containsKey(edgeId)) {
            return List.of();
        }
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>();
        HashSet updatePlayers = new HashSet();
        for (SectionPos section : this.collisionById.get(edgeId).sectionsIn()) {
            updatePlayers.addAll(this.playersWatchingChunk.get((Object)section.m_123251_()));
        }
        for (UUID playerId : updatePlayers) {
            Player player = this.level.m_46003_(playerId);
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            players.add(serverPlayer);
        }
        return players;
    }

    protected WireNode updateNodeData(WireNode node) {
        boolean swapNode;
        WireNode newNode = node.getData().updateWireNode(this, node);
        if (newNode == null) {
            return node;
        }
        boolean bl = swapNode = !node.getId().equals(newNode.getId());
        if (swapNode && ((Boolean)ModCommonConfig.WIRE_CONVERTER_LOGGING.get()).booleanValue()) {
            PantographsAndWires.LOGGER.info("[GRAPH CONVERTER/UPDATER]    - NODE SWAPPED: " + String.valueOf(node.getId()) + " -> " + String.valueOf(newNode.getId()) + ", with connections: " + node.getConnections().size());
        }
        for (UUID id : new ArrayList<UUID>(node.getConnections())) {
            if (!this.hasEdge(id)) {
                node.removeConnection(id);
                continue;
            }
            WireEdge edge = this.getEdge(id);
            if (swapNode) {
                this.replaceNodeInEdge(edge, node.getId(), newNode.getId(), true);
            }
            WireNode nodeA = this.getNode(edge.getNodeAId());
            WireNode nodeB = this.getNode(edge.getNodeBId());
            if (nodeA == null || nodeB == null) {
                return node;
            }
            CustomData customData = edge.getWireConnectionData().customData();
            WireConnectionData data = new WireConnectionData(customData, nodeA.getData().getConnectorCustomData(this, customData, nodeA, 0).orElse(edge.getWireConnectionData().connectorA()), nodeB.getData().getConnectorCustomData(this, customData, nodeB, 1).orElse(edge.getWireConnectionData().connectorB()));
            if (edge.getWireConnectionData().equals(data)) {
                return node;
            }
            edge.setWireConnectionData(data);
            if (swapNode) {
                this.setAndUpdateEdge(edge, false);
                continue;
            }
            this.updateEdge(edge, false);
        }
        return newNode;
    }

    public Collection<NewWireCollision> getCollisionsInChunk(ChunkPos chunk) {
        return Collections.unmodifiableCollection(this.collisionByChunk.get((Object)chunk));
    }

    public Collection<NewWireCollision> getCollisionsInBlock(BlockPos block) {
        return Collections.unmodifiableCollection(this.collisionByBlock.get((Object)block));
    }

    public Optional<NewWireCollision> getCollisionById(UUID id) {
        return Optional.ofNullable(this.collisionById.get(id));
    }

    public void notifyBlockUpdate(Level level, Optional<Player> player, BlockPos pos, BlockState newState, int flags) {
        if (((Boolean)ModServerConfig.BLOCKS_BREAK_WIRES.get()).booleanValue() && !level.m_5776_() && !newState.m_60812_((BlockGetter)level, pos).m_83281_()) {
            List<UUID> connections = this.getCollisionsInBlock(pos).stream().map(x -> x.getId()).toList();
            if (connections.isEmpty()) {
                return;
            }
            ArrayList<UUID> connectionsToBreak = new ArrayList<UUID>();
            for (UUID connection : connections) {
                Collection<NewWireCollision.WireBlockCollision> collisions = this.collisionById.get(connection).collisionsInBlock(pos);
                for (NewWireCollision.WireBlockCollision collision : collisions) {
                    Vector3f vecA = collision.getInVector();
                    Vector3f vecB = collision.getOutVector();
                    BlockPos dropPos = pos;
                    if (!NewWireCollision.isConnectionBlocked(level, pos, newState, vecA, vecB)) continue;
                    for (Direction d : Direction.values()) {
                        if (!level.m_46859_(pos.m_121945_(d))) continue;
                        dropPos = dropPos.m_121945_(d);
                        break;
                    }
                    if (connectionsToBreak.contains(connection)) continue;
                    connectionsToBreak.add(connection);
                }
            }
            for (UUID connection : connectionsToBreak) {
                this.removeEdge(connection, new Vector3f((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f), player);
            }
            ChunkPos chunk = new ChunkPos(pos);
            HashSet updatePlayers = new HashSet();
            if (this.playersWatchingChunk.containsKey((Object)chunk)) {
                updatePlayers.addAll(this.playersWatchingChunk.get((Object)chunk));
            }
            for (UUID playerId : updatePlayers) {
                Player player2 = level.m_46003_(playerId);
                if (!(player2 instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player2;
                WiresApi.net().CHANNEL.sendToPlayer(serverPlayer, (Object)new DeleteWireConnectionPacket(new DeleteWireSyncData(this.getId(), connectionsToBreak)));
            }
        }
    }

    public void checkEntityCollision(Level level, BlockPos pos, Entity entity) {
    }

    public void onChunkLoad(Level level, ChunkPos pos, Player player) {
        if (level.m_5776_()) {
            return;
        }
        this.playersWatchingChunk.put((Object)pos, (Object)player.m_20148_());
        if (this.nodesByChunk.containsKey((Object)pos) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LinkedHashSet<UUID> edgeIds = new LinkedHashSet<UUID>();
            ImmutableList nodeIds = ImmutableList.copyOf((Collection)this.nodesByChunk.get((Object)pos));
            for (UUID nodeId : nodeIds) {
                if (!this.hasNode(nodeId)) continue;
                WireNode node = this.updateNodeData(this.getNode(nodeId));
                if (((Boolean)ModCommonConfig.WIRE_CONVERTER_LOGGING.get()).booleanValue()) {
                    PantographsAndWires.LOGGER.info("[GRAPH CONVERTER/UPDATER] - NODE " + String.valueOf(nodeId) + ": " + node.getPos().x + ", " + node.getPos().y + ", " + node.getPos().z);
                }
                if (!node.getData().validate(this, new CompoundTag(), 0)) {
                    this.removeNode(nodeId, null, null);
                    PantographsAndWires.LOGGER.warn("Removed wire node with id {} and type {} at {}, because it is no longer valid.", new Object[]{node.getId(), node.getData().getClass().getSimpleName(), node.getPos()});
                    continue;
                }
                for (UUID connectionId : node.getConnections()) {
                    edgeIds.add(connectionId);
                }
            }
            if (edgeIds.isEmpty()) {
                return;
            }
            ArrayList<WireEdge> edges = new ArrayList<WireEdge>(edgeIds.size());
            HashSet<WireNode> nodes = new HashSet<WireNode>();
            for (UUID id : edgeIds) {
                WireEdge edge = this.getEdge(id);
                if (edge == null) continue;
                edges.add(edge);
                nodes.add(this.getNode(edge.getNodeAId()));
                nodes.add(this.getNode(edge.getNodeBId()));
            }
            WiresApi.net().CHANNEL.sendToPlayer(serverPlayer, (Object)new WireConnectorDataPacket(new WiresSyncData.Wrapper(new WiresSyncData(this.getId(), pos, () -> edges, () -> nodes, false))));
        }
    }

    public void onChunkUnload(Level level, ChunkPos pos, Player player) {
        if (this.playersWatchingChunk.containsKey((Object)pos)) {
            Predicate<UUID> playerTest = x -> x.equals(player.m_20148_());
            this.playersWatchingChunk.get((Object)pos).removeIf(playerTest);
        }
        if (this.collisionByChunk.containsKey((Object)pos) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            List<UUID> edgeIds = this.collisionByChunk.get((Object)pos).stream().map(x -> x.getId()).toList();
            if (edgeIds.isEmpty()) {
                return;
            }
            WiresApi.net().CHANNEL.sendToPlayer(serverPlayer, (Object)new WireConnectionChunkUnloadingPacket(new WireChunkUnloadingData(this.getId(), pos, edgeIds)));
        }
    }

    public final void upgrade(CompoundTag nbt) {
        int steps = 2;
        long startTime = 0L;
        PantographsAndWires.LOGGER.info("Converting wire data for dimension " + String.valueOf(this.level.m_46472_().m_135782_()) + "! This process may take a moment. Please wait...");
        PantographsAndWires.LOGGER.info("[WIRE CONVERSION] [STEP 1/2]: Reading and processing legacy data...");
        startTime = System.currentTimeMillis();
        List<CompoundTag> connectionsList = nbt.m_128437_("Connections", 10).stream().map(x -> (CompoundTag)x).toList();
        ArrayList<PrimitiveEdge> edges = new ArrayList<PrimitiveEdge>();
        int nodesCount = 0;
        for (CompoundTag connection : connectionsList) {
            PAWWireType type;
            String wireId;
            switch (wireId = connection.m_128461_("WireType")) {
                case "pantographsandwires:catenary_wire": {
                    PAWWireType pAWWireType = ModWireRegistry.CATENARY_WIRE;
                    break;
                }
                case "pantographsandwires:energy_wire": {
                    PAWWireType pAWWireType = ModWireRegistry.ENERGY_WIRE;
                    break;
                }
                default: {
                    PAWWireType pAWWireType = type = null;
                }
            }
            if (type == null) {
                PantographsAndWires.LOGGER.warn("[WIRE CONVERSION] Unknown wire type id '" + String.valueOf(type) + "''. This connection is skipped!");
                continue;
            }
            CompoundTag customData = new CompoundTag();
            if (wireId.equals("pantographsandwires:catenary_wire")) {
                int cantileverBIndex;
                CompoundTag customDataNbt = connection.m_128469_("CreationData");
                int cantileverAIndex = customDataNbt.m_128471_("ClickedRight1") ? 1 : 0;
                int n = cantileverBIndex = customDataNbt.m_128471_("ClickedRight2") ? 1 : 0;
                if (cantileverAIndex > 0 || cantileverBIndex > 0) {
                    CompoundTag pointNbt;
                    CompoundTag customPointData = new CompoundTag();
                    if (cantileverAIndex > 0) {
                        pointNbt = new CompoundTag();
                        pointNbt.m_128405_("CantileverIndex", cantileverAIndex);
                        customPointData.m_128365_("0", (Tag)pointNbt);
                    }
                    if (cantileverBIndex > 0) {
                        pointNbt = new CompoundTag();
                        pointNbt.m_128405_("CantileverIndex", cantileverBIndex);
                        customPointData.m_128365_("1", (Tag)pointNbt);
                    }
                    customData.m_128365_("CustomPointData", (Tag)customPointData);
                }
            }
            BlockPos nodeAPos = Utils.getNbtBlockPos(connection, "PosA");
            BlockPos nodeBPos = Utils.getNbtBlockPos(connection, "PosB");
            PrimitiveNode nodeA = new PrimitiveNode(UUID.randomUUID(), new BlockConnectorNodeData(nodeAPos), new Vector3f((float)nodeAPos.m_123341_(), (float)nodeAPos.m_123342_(), (float)nodeAPos.m_123343_()));
            PrimitiveNode nodeB = new PrimitiveNode(UUID.randomUUID(), new BlockConnectorNodeData(nodeBPos), new Vector3f((float)nodeBPos.m_123341_(), (float)nodeBPos.m_123342_(), (float)nodeBPos.m_123343_()));
            ++nodesCount;
            edges.add(new PrimitiveEdge(nodeA, nodeB, type, customData));
        }
        PantographsAndWires.LOGGER.info("[WIRE CONVERSION] [STEP 1 SUCCESS]: Found " + nodesCount + " nodes and " + edges.size() + " edges. Took " + (System.currentTimeMillis() - startTime) + "ms");
        PantographsAndWires.LOGGER.info("[WIRE CONVERSION] [STEP 2/2]: Converting data..");
        startTime = System.currentTimeMillis();
        for (PrimitiveEdge edge : edges) {
            MutableInt i = new MutableInt();
            this.createEdge(edge.type(), new CustomData(edge.customData()), edge.nodeA.nodeData(), edge.nodeB.nodeData(), i, false);
        }
        PantographsAndWires.LOGGER.info("[WIRE CONVERSION] [STEP 2 SUCCESS]: Took " + (System.currentTimeMillis() - startTime) + "ms");
        PantographsAndWires.LOGGER.info("[WIRE CONVERSION] [STATUS]: " + this.getStatistics().print(true));
    }

    public record CreateEdgeResult(boolean success, int code, Optional<WireEdge> edge) {
        public static final int CONNECTION_EXISTS = 0;
        public static final int INVALID_CONNECTOR = 1;
    }

    private record PrimitiveNode(UUID id, BlockConnectorNodeData nodeData, Vector3f pos) {
    }

    private record PrimitiveEdge(PrimitiveNode nodeA, PrimitiveNode nodeB, IWireType type, CompoundTag customData) {
    }
}

