/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import de.mrjulsen.wires.Wire;
import de.mrjulsen.wires.WireBatch;
import de.mrjulsen.wires.WireCreationContext;
import de.mrjulsen.wires.WirePoints;
import de.mrjulsen.wires.graph.DLStatistics;
import de.mrjulsen.wires.graph.IWireGraph;
import de.mrjulsen.wires.graph.NewWireCollision;
import de.mrjulsen.wires.graph.WireEdge;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.WireEdgeHash;
import de.mrjulsen.wires.graph.data.accessor.NodeAccessor;
import de.mrjulsen.wires.network.WireChunkUnloadingData;
import de.mrjulsen.wires.render.WireSegmentRenderDataBatch;
import de.mrjulsen.wires.util.GraphId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class WireGraphClient
implements IWireGraph {
    private final GraphId id;
    private final Level level;
    private final Map<UUID, WireNode> nodes = new HashMap<UUID, WireNode>();
    private final Map<UUID, WireEdge> edges = new HashMap<UUID, WireEdge>();
    private final Map<ResourceLocation, NodeAccessor<?>> nodesByType = new ConcurrentHashMap();
    private final Multimap<WireNode, WireEdge> edgesByNode = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    private final Map<WireEdgeHash, WireEdge> edgesByHash = new ConcurrentHashMap<WireEdgeHash, WireEdge>();
    final Map<UUID, NewWireCollision> collisionById = new HashMap<UUID, NewWireCollision>();
    final Multimap<BlockPos, NewWireCollision> collisionByBlock = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    final Multimap<ChunkPos, NewWireCollision> collisionByChunk = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    final Multimap<SectionPos, NewWireCollision> collisionBySection = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    final Multimap<UUID, WireSegmentRenderDataBatch> renderDataById = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    final Multimap<ChunkPos, WireSegmentRenderDataBatch> renderDataByChunk = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    final Multimap<SectionPos, WireSegmentRenderDataBatch> renderDataBySection = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    private final Multimap<UUID, DebugWireData> debugWireDataByEdge = MultimapBuilder.hashKeys().linkedListValues().build();

    public WireGraphClient(GraphId id, Level level) {
        this.id = id;
        this.level = level;
    }

    @Override
    public DLStatistics getStatistics() {
        DLStatistics.Group nodesGroup = new DLStatistics.Group("nodes", "N");
        DLStatistics.Group edgesGroup = new DLStatistics.Group("edges", "E");
        DLStatistics.Group collisionsGroup = new DLStatistics.Group("collisions", "C");
        DLStatistics.Group renderingGroup = new DLStatistics.Group("rendering", "R");
        return new DLStatistics("Wires[C]", List.of(new DLStatistics.Stat(nodesGroup, "Nodes", this.nodes.size()), new DLStatistics.Stat(edgesGroup, "Edges", this.edges.size()), new DLStatistics.Stat(edgesGroup, "Edges (by node)", this.edgesByNode.size()), new DLStatistics.Stat(edgesGroup, "Edges (by hash)", this.edgesByHash.size()), new DLStatistics.Stat(edgesGroup, "Debug Wire Data", this.debugWireDataByEdge.size()), new DLStatistics.Stat(collisionsGroup, "Collision", this.collisionById.size()), new DLStatistics.Stat(collisionsGroup, "Collision (by block)", this.collisionByBlock.size()), new DLStatistics.Stat(collisionsGroup, "Collision (by section)", this.collisionBySection.size()), new DLStatistics.Stat(collisionsGroup, "Collision (by chunk)", this.collisionByChunk.size()), new DLStatistics.Stat(renderingGroup, "Rendering", this.renderDataById.size()), new DLStatistics.Stat(renderingGroup, "Rendering (by section)", this.renderDataBySection.size()), new DLStatistics.Stat(renderingGroup, "Rendering (by chunk)", this.renderDataByChunk.size())));
    }

    @Override
    public GraphId getId() {
        return this.id;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public <A extends NodeAccessor<?>> Optional<A> accessNodesOfType(ResourceLocation typeId) {
        return Optional.ofNullable(this.nodesByType.containsKey(typeId) ? this.nodesByType.get(typeId) : null);
    }

    @Override
    public WireNode getNode(UUID id) {
        return this.nodes.get(id);
    }

    @Override
    public WireEdge getEdge(UUID id) {
        return this.edges.get(id);
    }

    public WireEdge getEdge(WireEdgeHash hash) {
        return this.edgesByHash.get(hash);
    }

    @Override
    public Collection<WireNode> getNodes() {
        return Collections.synchronizedCollection(Collections.unmodifiableCollection(this.nodes.values()));
    }

    @Override
    public Collection<WireEdge> getEdges() {
        return Collections.synchronizedCollection(Collections.unmodifiableCollection(this.edges.values()));
    }

    @Override
    public boolean hasEdge(UUID id) {
        return this.edges.containsKey(id);
    }

    @Override
    public boolean hasNode(UUID id) {
        return this.nodes.containsKey(id);
    }

    public boolean hasEdge(WireEdgeHash hash) {
        return this.edgesByHash.containsKey(hash);
    }

    private synchronized void setSectionDirty(SectionPos pos) {
        Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().f_91060_.m_109770_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
    }

    public void addNode(WireNode node) {
        this.nodes.computeIfAbsent(node.getId(), $ -> node);
        WireNode n = this.nodes.get(node.getId());
        this.nodesByType.computeIfAbsent(node.getData().getRegistryType().id(), a -> node.getData().getRegistryType().createAccessor()).put(n);
    }

    public void removeNode(UUID id) {
        WireNode node = this.nodes.remove(id);
        if (node == null) {
            return;
        }
        this.edgesByNode.removeAll((Object)node);
        this.nodesByType.get(node.getData().getRegistryType().id()).remove(node);
    }

    public WireEdge addEdge(WireEdge edge, boolean force) {
        if (!this.hasNode(edge.getNodeAId()) || !this.hasNode(edge.getNodeBId())) {
            return edge;
        }
        WireNode nodeA = this.getNode(edge.getNodeAId());
        WireNode nodeB = this.getNode(edge.getNodeBId());
        if (!force && this.hasEdge(edge.getHash())) {
            return edge;
        }
        WireBatch batch = edge.getType().buildWire(WireCreationContext.BOTH, (BlockAndTintGetter)this.getLevel(), edge.getWireConnectionData(), edge, nodeA, nodeB);
        if (batch == null) {
            return edge;
        }
        this.removeEdgeInternal(edge.getId(), false);
        this.edges.put(edge.getId(), edge);
        this.edgesByNode.put((Object)nodeA, (Object)edge);
        this.edgesByNode.put((Object)nodeB, (Object)edge);
        this.edgesByHash.put(edge.getHash(), edge);
        nodeA.addConnection(edge.getId());
        nodeB.addConnection(edge.getId());
        for (Map.Entry<String, Wire> entry : batch.getWires().entrySet()) {
            this.debugWireDataByEdge.put((Object)edge.getId(), (Object)new DebugWireData(entry.getKey(), entry.getValue().pos()));
        }
        NewWireCollision collision = new NewWireCollision(this, edge.getId(), (Map<String, WirePoints>)batch.getCollisions());
        this.collisionById.put(edge.getId(), collision);
        for (BlockPos blockPos : collision.blocksIn()) {
            this.collisionByBlock.put((Object)blockPos, (Object)collision);
        }
        for (SectionPos sectionPos : collision.sectionsIn()) {
            this.collisionBySection.put((Object)sectionPos, (Object)collision);
        }
        for (ChunkPos chunkPos : collision.chunksIn()) {
            this.collisionByChunk.put((Object)chunkPos, (Object)collision);
        }
        HashSet hashSet = new HashSet();
        batch.splitRenderDataInChunkSections(edge.getId(), edge.getDecorations()).forEach((sec, seg) -> {
            this.renderDataById.put((Object)seg.getId(), seg);
            this.renderDataByChunk.put((Object)sec.m_123251_(), seg);
            this.renderDataBySection.put(sec, seg);
            sectionsIn.add(sec);
        });
        for (SectionPos section : hashSet) {
            this.setSectionDirty(section);
        }
        return edge;
    }

    public void removeEdge(UUID id) {
        this.removeEdgeInternal(id, true);
    }

    private void removeEdgeInternal(UUID id, boolean checkForEmptyNodes) {
        WireEdge edge = this.edges.remove(id);
        if (edge == null) {
            return;
        }
        Predicate<WireEdge> edgeTest = x -> x.getId().equals(edge.getId());
        this.edgesByNode.values().removeIf(edgeTest);
        this.edgesByHash.values().removeIf(edgeTest);
        this.debugWireDataByEdge.removeAll((Object)id);
        if (checkForEmptyNodes) {
            if (!this.getNode(edge.getNodeAId()).removeConnection(id)) {
                this.removeNode(edge.getNodeAId());
            }
            if (!this.getNode(edge.getNodeBId()).removeConnection(id)) {
                this.removeNode(edge.getNodeBId());
            }
        }
        Collection renderdata = this.renderDataById.removeAll((Object)id);
        this.renderDataBySection.values().removeAll(renderdata);
        this.renderDataByChunk.values().removeAll(renderdata);
        NewWireCollision collision = this.collisionById.remove(id);
        if (collision == null) {
            return;
        }
        Predicate<NewWireCollision> collisionTest = x -> x == collision;
        this.collisionByChunk.values().removeIf(collisionTest);
        this.collisionBySection.values().removeIf(collisionTest);
        this.collisionByBlock.values().removeIf(collisionTest);
        for (WireSegmentRenderDataBatch batch : renderdata) {
            SectionPos section = batch.getSection();
            this.setSectionDirty(section);
        }
    }

    public void onClientChunkUnloading(WireChunkUnloadingData in) {
        HashSet<UUID> emptyConnections = new HashSet<UUID>();
        for (WireSegmentRenderDataBatch renderdata : this.renderDataByChunk.get((Object)in.pos())) {
            renderdata.setUnloaded(true);
            if (this.renderDataById.containsKey((Object)renderdata.getId()) && !this.renderDataById.get((Object)renderdata.getId()).stream().allMatch(WireSegmentRenderDataBatch::isUnloaded)) continue;
            emptyConnections.add(renderdata.getId());
        }
        for (UUID id : emptyConnections) {
            this.removeEdge(id);
        }
    }

    public Collection<DebugWireData> debug_getWireDataForEdge(UUID edgeId) {
        return this.debugWireDataByEdge.containsKey((Object)edgeId) ? Collections.unmodifiableCollection(this.debugWireDataByEdge.get((Object)edgeId)) : List.of();
    }

    public boolean hasConnectionsInSection(SectionPos section) {
        return this.renderDataBySection.containsKey((Object)section);
    }

    public Collection<WireSegmentRenderDataBatch> connectionsInSection(SectionPos section) {
        if (!this.hasConnectionsInSection(section)) {
            return List.of();
        }
        return Collections.unmodifiableCollection(this.renderDataBySection.get((Object)section));
    }

    public Collection<NewWireCollision> getCollisionsInChunk(ChunkPos chunk) {
        return Collections.unmodifiableCollection(this.collisionByChunk.get((Object)chunk));
    }

    public Collection<NewWireCollision> getCollisionsInBlock(BlockPos pos) {
        return Collections.unmodifiableCollection(this.collisionByBlock.get((Object)pos));
    }

    public Optional<NewWireCollision> getCollisionById(UUID id) {
        return Optional.ofNullable(this.collisionById.get(id));
    }

    public record DebugWireData(String name, Vector3f centerPos) {
    }
}

