/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph;

import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.util.GraphId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public final class WireGraphManager {
    private static final Map<GraphId, GraphFactory> graphFactories = new ConcurrentHashMap<GraphId, GraphFactory>();
    private static final Map<GraphId, GraphClientFactory> graphClientFactories = new ConcurrentHashMap<GraphId, GraphClientFactory>();
    private static final Map<ResourceLocation, Map<GraphId, WireGraph>> graphs = new ConcurrentHashMap<ResourceLocation, Map<GraphId, WireGraph>>();
    private static final Map<ResourceLocation, Map<GraphId, WireGraphClient>> clientGraphs = new ConcurrentHashMap<ResourceLocation, Map<GraphId, WireGraphClient>>();

    private WireGraphManager() {
    }

    public static GraphId register(String name, GraphFactory commonFactory, GraphClientFactory clientFactory) {
        GraphId id = new GraphId(name);
        if (graphFactories.containsKey(id) || graphClientFactories.containsKey(id)) {
            throw new IllegalStateException("A wire graph with the ID '" + String.valueOf(id) + "' is already registered!");
        }
        graphFactories.put(id, commonFactory);
        graphClientFactories.put(id, clientFactory);
        return id;
    }

    private static WireGraphClient createClientGraph(GraphId id, Level level) {
        if (!graphClientFactories.containsKey(id)) {
            throw new IllegalStateException("A wire graph with the ID '" + String.valueOf(id) + "' is not registered!");
        }
        return graphClientFactories.get(id).build(id, level);
    }

    public static void build(ServerLevel level) {
        for (Map.Entry<GraphId, GraphFactory> factory : graphFactories.entrySet()) {
            GraphId id = factory.getKey();
            WireGraph graph = factory.getValue().build(id, (Level)level);
            graphs.computeIfAbsent(level.m_220362_().m_135782_(), x -> new HashMap()).put(id, graph);
            level.m_8895_().m_164861_(nbt -> graph.load(level, (CompoundTag)nbt), () -> graph, graph.getFileId());
        }
    }

    public static void clearServer() {
        graphs.clear();
    }

    public static void clearClient() {
        clientGraphs.clear();
    }

    public static synchronized WireGraph get(Level level, GraphId id) {
        return graphs.get(level.m_220362_().m_135782_()).get(id);
    }

    public static synchronized WireGraphClient getClient(Level level, GraphId id) {
        return clientGraphs.computeIfAbsent(level.m_220362_().m_135782_(), x -> new HashMap()).computeIfAbsent(id, x -> WireGraphManager.createClientGraph(x, level));
    }

    public static synchronized Collection<WireGraph> getAll(Level level) {
        if (!graphs.containsKey(level.m_220362_().m_135782_())) {
            return List.of();
        }
        return Collections.unmodifiableCollection(graphs.get(level.m_220362_().m_135782_()).values());
    }

    public static synchronized Collection<WireGraphClient> getAllClient(Level level) {
        if (!clientGraphs.containsKey(level.m_220362_().m_135782_())) {
            return List.of();
        }
        return Collections.unmodifiableCollection(clientGraphs.get(level.m_220362_().m_135782_()).values());
    }

    public static interface GraphClientFactory {
        public WireGraphClient build(GraphId var1, Level var2);
    }

    public static interface GraphFactory {
        public WireGraph build(GraphId var1, Level var2);
    }
}

