/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph;

import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.graph.IWireGraph;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WireNode {
    protected static final String NBT_ID = "Id";
    protected static final String NBT_POS = "Pos";
    protected static final String NBT_DATA = "NodeData";
    protected static final String NBT_CONNECTIONS = "Connections";
    private IWireGraph graph;
    private final UUID id;
    private final NodeData data;
    private Vector3f pos;
    private Set<UUID> connectedWires = new HashSet<UUID>();

    public WireNode(WireGraph graph, NodeData data) {
        this(graph, data, graph.createNewNodeId());
    }

    private WireNode(IWireGraph graph, NodeData data, UUID id) {
        this.graph = graph;
        this.data = data;
        this.id = id;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_(NBT_ID, this.id);
        nbt.m_128365_(NBT_DATA, (Tag)this.data.getRegistryType().wrap(this.data));
        Utils.putNbtVector3f(nbt, NBT_POS, this.pos);
        ListTag connectionsList = new ListTag();
        for (UUID cId : this.connectedWires) {
            connectionsList.add((Object)NbtUtils.m_129226_((UUID)cId));
        }
        nbt.m_128365_(NBT_CONNECTIONS, (Tag)connectionsList);
        return nbt;
    }

    public static Optional<WireNode> fromNbt(IWireGraph graph, CompoundTag nbt) {
        try {
            List<UUID> connections = nbt.m_128437_(NBT_CONNECTIONS, 11).stream().map(x -> NbtUtils.m_129233_((Tag)x)).toList();
            WireNode node = new WireNode(graph, WiresApi.NODE_DATA_REGISTRY.load(nbt.m_128469_(NBT_DATA)), nbt.m_128342_(NBT_ID));
            node.pos = Utils.getNbtVector3f(nbt, NBT_POS);
            node.connectedWires.addAll(connections);
            return Optional.of(node);
        }
        catch (Exception e) {
            WiresApi.LOGGER.error("Could not load wire node, because the nbt data is invalid: " + String.valueOf(nbt), (Throwable)e);
            return Optional.empty();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof WireNode) {
            WireNode o = (WireNode)obj;
            return this.id.equals(o.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public IWireGraph getGraph() {
        return this.graph;
    }

    public void setGraph(IWireGraph graph) {
        this.graph = graph;
    }

    public UUID getId() {
        return this.id;
    }

    public Vector3f getPos() {
        return new Vector3f((Vector3fc)this.pos);
    }

    public void setPos(Vector3f pos) {
        this.pos = new Vector3f((Vector3fc)pos);
    }

    public void addConnection(UUID id) {
        this.connectedWires.add(id);
    }

    public boolean removeConnection(UUID id) {
        this.connectedWires.remove(id);
        return !this.connectedWires.isEmpty();
    }

    public void onRemove(Level level, Vector3f breakPosition, Optional<Player> player) {
        this.getData().onRemove(level, breakPosition, player);
    }

    public NodeData getData() {
        return this.data;
    }

    public Collection<UUID> getConnections() {
        return Collections.synchronizedCollection(this.connectedWires);
    }
}

