/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph.data;

import de.mrjulsen.paw.PantographsAndWires;
import de.mrjulsen.paw.config.ModCommonConfig;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.item.CustomData;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.CompoundTag;

public class WireEdgeHash {
    private final byte[] data;
    private final int hash;

    public WireEdgeHash(CustomData customData, NodeData nodeA, NodeData nodeB) {
        this.data = WireEdgeHash.compressStringToGzipBytes(customData.nbt(), nodeA.serializeNbt(), nodeB.serializeNbt());
        this.hash = Arrays.hashCode(this.data);
    }

    public WireEdgeHash(CustomData customData, WireNode nodeA, WireNode nodeB) {
        this(customData, nodeA.getData(), nodeB.getData());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WireEdgeHash)) {
            return false;
        }
        WireEdgeHash h = (WireEdgeHash)o;
        return Arrays.equals(this.data, h.data);
    }

    public int hashCode() {
        return this.hash;
    }

    private static byte[] encode(CompoundTag ... objects) {
        ArrayList<String> parts = new ArrayList<String>();
        for (CompoundTag obj : objects) {
            parts.add(obj.toString());
        }
        Collections.sort(parts);
        String s = String.join((CharSequence)"", parts);
        return s.getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] compressStringToGzipBytes(CompoundTag ... objects) {
        byte[] encodedData = WireEdgeHash.encode(objects);
        if (!((Boolean)ModCommonConfig.COMPRESS_HASH_VALUES.get()).booleanValue()) {
            return encodedData;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOS = new GZIPOutputStream(bos);){
            gzipOS.write(encodedData);
        }
        catch (Exception e) {
            PantographsAndWires.LOGGER.error("Could not compress hash for wire edge data.", (Throwable)e);
            return encodedData;
        }
        return bos.toByteArray();
    }
}

