/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph.data.accessor;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.accessor.NodeAccessor;
import de.mrjulsen.wires.graph.data.node.INodeDataWire;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.network.WireId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class GenericWireNodeAccessor<T extends NodeData>
extends NodeAccessor<T> {
    private final Multimap<WireId, WireNode> nodesByWire = MultimapBuilder.hashKeys().arrayListValues().build();
    private final Multimap<UUID, WireNode> nodesByEdge = MultimapBuilder.hashKeys().arrayListValues().build();

    @Override
    public void put(WireNode node) {
        this.nodesByWire.put((Object)((INodeDataWire)this.getNodeData(node)).getWireId(), (Object)node);
        this.nodesByEdge.put((Object)((INodeDataWire)this.getNodeData(node)).getWireId().id(), (Object)node);
    }

    @Override
    public void remove(WireNode node) {
        this.nodesByWire.values().removeIf(x -> x.equals(node));
        this.nodesByEdge.values().removeIf(x -> x.equals(node));
    }

    public Collection<WireNode> get(WireId id) {
        if (this.nodesByWire.containsKey((Object)id)) {
            return Collections.unmodifiableCollection(this.nodesByWire.get((Object)id));
        }
        return List.of();
    }

    public Collection<WireNode> get(UUID edgeId) {
        if (this.nodesByEdge.containsKey((Object)edgeId)) {
            return Collections.unmodifiableCollection(this.nodesByEdge.get((Object)edgeId));
        }
        return List.of();
    }
}

