/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph.data.node;

import de.mrjulsen.paw.PantographsAndWires;
import de.mrjulsen.paw.config.ModCommonConfig;
import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.block.IWireConnector;
import de.mrjulsen.wires.block.WireConnectorBlockEntity;
import de.mrjulsen.wires.graph.IWireGraph;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.accessor.NodeAccessor;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.graph.data.provider.ConnectorDataProvider;
import de.mrjulsen.wires.graph.registry.NodeDataRegistryObject;
import de.mrjulsen.wires.item.CustomData;
import de.mrjulsen.wires.util.NodeId;
import de.mrjulsen.wires.util.SafeChunkUtils;
import de.mrjulsen.wires.util.Utils;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Vector3f;

public class BlockConnectorNodeData
extends NodeData {
    private static final String NBT_POS = "Pos";
    private static final String NBT_PENDING = "IsPending";
    private BlockPos pos;
    private boolean pending;

    public BlockConnectorNodeData() {
    }

    public BlockConnectorNodeData(BlockPos pos) {
        this.pos = pos;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isPending() {
        return this.pending;
    }

    @Override
    public NodeDataRegistryObject<NodeData, NodeAccessor<NodeData>> getRegistryType() {
        return WiresApi.BLOCK_CONNECTOR;
    }

    public CompoundTag serializeNbt() {
        CompoundTag nbt = new CompoundTag();
        Utils.putNbtBlockPos(nbt, NBT_POS, this.pos);
        if (this.pending) {
            nbt.m_128379_(NBT_PENDING, this.pending);
        }
        return nbt;
    }

    public void deserializeNbt(CompoundTag nbt) {
        this.pos = Utils.getNbtBlockPos(nbt, NBT_POS);
        this.pending = nbt.m_128471_(NBT_PENDING);
    }

    @Override
    public WireNode getOrCreateNode(WireGraph graph) {
        BlockEntity blockEntity;
        if (graph.getLevel().m_46749_(this.getPos()) && (blockEntity = graph.getLevel().m_7702_(this.getPos())) instanceof WireConnectorBlockEntity) {
            WireConnectorBlockEntity be = (WireConnectorBlockEntity)blockEntity;
            if (graph.getLevel().m_8055_(this.getPos()).m_60734_() instanceof IWireConnector) {
                WireNode node = null;
                if (be.getNodeId() == null || !graph.hasNode(be.getNodeId().id())) {
                    node = graph.createNode(this, new Vector3f((float)this.getPos().m_123341_(), (float)this.getPos().m_123342_(), (float)this.getPos().m_123343_()));
                    be.setNodeId(new NodeId(node.getId(), graph.getId()));
                } else {
                    node = graph.getNode(be.getNodeId().id());
                }
                return node;
            }
        }
        this.pending = true;
        return graph.createNode(this, new Vector3f((float)this.getPos().m_123341_(), (float)this.getPos().m_123342_(), (float)this.getPos().m_123343_()));
    }

    public boolean isTest() {
        return this.pos.m_123341_() == 1103 && this.pos.m_123342_() == 8 && this.pos.m_123343_() == -4877 || this.pos.m_123341_() == -164 && this.pos.m_123342_() == 77 && this.pos.m_123343_() == -56;
    }

    @Override
    public WireNode updateWireNode(WireGraph graph, WireNode node) {
        boolean wasPending = this.pending;
        if (this.pending) {
            this.pending = false;
            BlockEntity blockEntity = graph.getLevel().m_7702_(this.getPos());
            if (blockEntity instanceof WireConnectorBlockEntity) {
                WireConnectorBlockEntity be = (WireConnectorBlockEntity)blockEntity;
                if (graph.getLevel().m_8055_(this.getPos()).m_60734_() instanceof IWireConnector) {
                    WireNode newNode = null;
                    if (be.getNodeId() == null || !graph.hasNode(be.getNodeId().id())) {
                        newNode = graph.createNode(this, new Vector3f((float)this.getPos().m_123341_(), (float)this.getPos().m_123342_(), (float)this.getPos().m_123343_()));
                        be.setNodeId(new NodeId(newNode.getId(), graph.getId()));
                        if (((Boolean)ModCommonConfig.WIRE_CONVERTER_LOGGING.get()).booleanValue()) {
                            PantographsAndWires.LOGGER.info("[GRAPH CONVERTER/UPDATER]        - Create new node: " + String.valueOf(newNode.getId()));
                        }
                    } else {
                        newNode = graph.getNode(be.getNodeId().id());
                        if (((Boolean)ModCommonConfig.WIRE_CONVERTER_LOGGING.get()).booleanValue()) {
                            PantographsAndWires.LOGGER.info("[GRAPH CONVERTER/UPDATER]        - Use existing node: " + String.valueOf(newNode.getId()));
                        }
                    }
                    return newNode;
                }
            }
        }
        if (((Boolean)ModCommonConfig.WIRE_CONVERTER_LOGGING.get()).booleanValue()) {
            PantographsAndWires.LOGGER.info("[GRAPH CONVERTER/UPDATER]        - COULD NOT REPLACE DUMMY NODE! This is not intended, but could occur if there is no longer a valid connector block at the corresponding location.");
        }
        return wasPending ? node : null;
    }

    @Override
    public Optional<ConnectorDataProvider> getConnectorCustomData(WireGraph graph, CustomData customData, WireNode node, int pointIndex) {
        Block block;
        if (!this.pending && graph.getLevel().m_46749_(this.getPos()) && SafeChunkUtils.getSafeBE((LevelAccessor)graph.getLevel(), this.getPos()) instanceof WireConnectorBlockEntity && (block = SafeChunkUtils.getBlockState((LevelAccessor)graph.getLevel(), this.getPos()).m_60734_()) instanceof IWireConnector) {
            IWireConnector connector = (IWireConnector)block;
            return Optional.of(connector.getConnectorData(graph.getLevel(), this.getPos(), customData, pointIndex));
        }
        return Optional.empty();
    }

    @Override
    public Vector3f toWorldPos(IWireGraph graph) {
        return new Vector3f((float)this.getPos().m_123341_(), (float)this.getPos().m_123342_(), (float)this.getPos().m_123343_());
    }

    @Override
    public boolean validate(WireGraph graph, CompoundTag currentItemData, int pointIndex) {
        return this.pending || !graph.getLevel().m_46749_(this.getPos()) || graph.getLevel().m_7702_(this.getPos()) instanceof WireConnectorBlockEntity;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockConnectorNodeData) {
            BlockConnectorNodeData o = (BlockConnectorNodeData)obj;
            return this.getPos().equals((Object)o.getPos());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getPos());
    }
}

