/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph.data.node;

import de.mrjulsen.paw.block.RegistrationArmBlock;
import de.mrjulsen.paw.item.CatenaryHeadspanWireType;
import de.mrjulsen.paw.registry.RegistrationArmWireDecoration;
import de.mrjulsen.paw.util.ModMath;
import de.mrjulsen.wires.WirePoints;
import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.graph.IWireGraph;
import de.mrjulsen.wires.graph.NewWireCollision;
import de.mrjulsen.wires.graph.WireEdge;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.accessor.NodeAccessor;
import de.mrjulsen.wires.graph.data.node.INodeDataWire;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.graph.data.provider.CantileverConnectorDataProvider;
import de.mrjulsen.wires.graph.data.provider.ConnectorDataProvider;
import de.mrjulsen.wires.graph.registry.NodeDataRegistryObject;
import de.mrjulsen.wires.item.CustomData;
import de.mrjulsen.wires.network.WireId;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CatenaryHeadspanConnectionNodeData
extends NodeData
implements INodeDataWire {
    private static final String NBT_WIRE_ID = "WireId";
    private WireId wireId;

    public CatenaryHeadspanConnectionNodeData() {
    }

    public CatenaryHeadspanConnectionNodeData(WireId wireId) {
        this.wireId = wireId;
    }

    @Override
    public NodeDataRegistryObject<NodeData, NodeAccessor<NodeData>> getRegistryType() {
        return WiresApi.CATENARY_HEADSPAN;
    }

    @Override
    public WireId getWireId() {
        return this.wireId;
    }

    public CompoundTag serializeNbt() {
        CompoundTag nbt = new CompoundTag();
        if (this.wireId != null) {
            nbt.m_128365_(NBT_WIRE_ID, (Tag)this.wireId.toNbt());
        }
        return nbt;
    }

    public void deserializeNbt(CompoundTag nbt) {
        if (nbt.m_128441_(NBT_WIRE_ID)) {
            this.wireId = WireId.fromNbt(nbt.m_128469_(NBT_WIRE_ID)).orElse(null);
        }
    }

    @Override
    public WireNode getOrCreateNode(WireGraph graph) {
        if (this.wireId == null) {
            return null;
        }
        WireNode node = WiresApi.CATENARY_HEADSPAN.getAccessor(graph).map(x -> x.get(this.wireId).stream().findFirst().orElse(null)).orElseGet(() -> {
            WireEdge edge = graph.getEdge(this.wireId.id());
            NewWireCollision collision = graph.getCollisionById(this.wireId.id()).orElse(null);
            if (edge == null || collision == null) {
                return null;
            }
            WirePoints points = collision.getWirePointsOf(this.wireId.name());
            return graph.createNode(this, points.vertices()[0]);
        });
        return node;
    }

    @Override
    public WireNode updateWireNode(WireGraph graph, WireNode node) {
        if (this.wireId == null) {
            return null;
        }
        WireEdge edge = graph.getEdge(this.wireId.id());
        NewWireCollision collision = graph.getCollisionById(this.wireId.id()).orElse(null);
        if (edge == null || collision == null) {
            return null;
        }
        WirePoints points = collision.getWirePointsOf(this.wireId.name());
        if (points == null) {
            return null;
        }
        node.setPos(points.vertices()[0]);
        return node;
    }

    @Override
    public Optional<ConnectorDataProvider> getConnectorCustomData(WireGraph graph, CustomData customData, WireNode node, int pointIndex) {
        if (this.wireId == null) {
            return Optional.empty();
        }
        WireEdge edge = graph.getEdge(this.wireId.id());
        NewWireCollision collision = graph.getCollisionById(this.wireId.id()).orElse(null);
        Optional<UUID> dropperIdOpt = CatenaryHeadspanWireType.toDropperId(this.wireId.name());
        if (edge == null || collision == null || dropperIdOpt.isEmpty()) {
            return Optional.empty();
        }
        WirePoints dropperWirePoints = collision.getWirePointsOf(this.wireId.name());
        WirePoints tensionWirePoints = collision.getWirePointsOf("lower_tension_wire");
        if (dropperWirePoints == null || tensionWirePoints == null) {
            return Optional.empty();
        }
        boolean b = edge.getWireConnectionData().customData().getCommonData().m_128457_("UpperWireHeight") > 1.5f;
        Optional<RegistrationArmWireDecoration> registrationArm = CatenaryHeadspanWireType.getRegistrationArmForDropper(edge, dropperIdOpt.get());
        if (!registrationArm.isPresent()) {
            return Optional.empty();
        }
        Vector3f headspanDirection = new Vector3f((Vector3fc)tensionWirePoints.vertices()[tensionWirePoints.vertices().length - 1]).sub((Vector3fc)tensionWirePoints.vertices()[0]).normalize();
        Vector3f offset = new Vector3f(registrationArm.map(x -> Float.valueOf(x.getVariant() == RegistrationArmBlock.State.NORMAL_CENTERED || x.getVariant() == RegistrationArmBlock.State.ABOVE_CENTERED ? 0.0f : (x.isMirrored() ? 0.25f : -0.25f))).orElse(Float.valueOf(0.0f)).floatValue(), 0.0f, 0.0f);
        Vector3f offsetVec = ModMath.rotateToDirection(offset, headspanDirection);
        return Optional.of(new CantileverConnectorDataProvider(new Vector3f(offsetVec.x(), registrationArm.map(x -> Float.valueOf(x.getVariant().isAbove() ? 0.25f : -0.375f)).orElse(Float.valueOf(0.0f)).floatValue(), offsetVec.z()), new Vector3f((Vector3fc)dropperWirePoints.vertices()[dropperWirePoints.vertices().length - 1]).sub((Vector3fc)node.getPos()).add(0.0f, b ? -0.7f : 0.0f, 0.0f)));
    }

    @Override
    public Vector3f toWorldPos(IWireGraph graph) {
        NewWireCollision collision;
        if (this.wireId == null) {
            return new Vector3f();
        }
        WireEdge edge = graph.getEdge(this.wireId.id());
        if (graph instanceof WireGraph) {
            WireGraph g = (WireGraph)graph;
            v0 = g.getCollisionById(this.wireId.id()).orElse(null);
        } else if (graph instanceof WireGraphClient) {
            WireGraphClient gc = (WireGraphClient)graph;
            v0 = gc.getCollisionById(this.wireId.id()).orElse(null);
        } else {
            v0 = collision = null;
        }
        if (edge == null || collision == null) {
            return new Vector3f();
        }
        WireNode originNode = graph.getNode(edge.getNodeAId());
        return originNode.getPos();
    }

    @Override
    public boolean validate(WireGraph graph, CompoundTag currentItemData, int pointIndex) {
        return graph.getCollisionById(this.wireId.id()).map(x -> x.hasWire(this.wireId.name())).orElse(false);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CatenaryHeadspanConnectionNodeData) {
            CatenaryHeadspanConnectionNodeData o = (CatenaryHeadspanConnectionNodeData)obj;
            return this.wireId.equals(o.wireId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.wireId);
    }
}

