/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph.data.node;

import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.graph.IWireGraph;
import de.mrjulsen.wires.graph.NewWireCollision;
import de.mrjulsen.wires.graph.WireEdge;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.accessor.NodeAccessor;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.graph.data.provider.CantileverConnectorDataProvider;
import de.mrjulsen.wires.graph.data.provider.ConnectorDataProvider;
import de.mrjulsen.wires.graph.registry.NodeDataRegistryObject;
import de.mrjulsen.wires.item.CustomData;
import de.mrjulsen.wires.network.WireId;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.joml.Vector3f;

public class CatenaryWireConnectorNodeData
extends NodeData {
    private static final String NBT_WIRE_ID = "WireId";
    private static final String NBT_POS = "PosPercentage";
    private WireId wireId;
    private float posPercentage;

    public CatenaryWireConnectorNodeData() {
    }

    public CatenaryWireConnectorNodeData(WireId wireId, float posPercentage) {
        this.wireId = wireId;
        this.posPercentage = posPercentage;
    }

    @Override
    public NodeDataRegistryObject<NodeData, NodeAccessor<NodeData>> getRegistryType() {
        return WiresApi.WIRE_CONNECTOR;
    }

    public CompoundTag serializeNbt() {
        CompoundTag nbt = new CompoundTag();
        if (this.wireId != null) {
            nbt.m_128365_(NBT_WIRE_ID, (Tag)this.wireId.toNbt());
        }
        nbt.m_128350_(NBT_POS, this.posPercentage);
        return nbt;
    }

    public void deserializeNbt(CompoundTag nbt) {
        if (nbt.m_128441_(NBT_WIRE_ID)) {
            this.wireId = WireId.fromNbt(nbt.m_128469_(NBT_WIRE_ID)).orElse(null);
        }
        this.posPercentage = nbt.m_128457_(NBT_POS);
    }

    @Override
    public WireNode getOrCreateNode(WireGraph graph) {
        if (this.wireId == null) {
            return null;
        }
        WireEdge edge = graph.getEdge(this.wireId.id());
        NewWireCollision collision = graph.getCollisionById(this.wireId.id()).orElse(null);
        if (edge == null || collision == null) {
            return null;
        }
        float length = collision.length(this.wireId.name());
        float posOnWire = length * this.posPercentage;
        Vector3f pos = collision.wirePosToWorldPos(this.wireId.name(), posOnWire);
        return graph.createNode(this, pos);
    }

    @Override
    public WireNode updateWireNode(WireGraph graph, WireNode node) {
        if (this.wireId == null) {
            return null;
        }
        WireEdge edge = graph.getEdge(this.wireId.id());
        NewWireCollision collision = graph.getCollisionById(this.wireId.id()).orElse(null);
        if (edge == null || collision == null) {
            return null;
        }
        float length = collision.length(this.wireId.name());
        float posOnWire = length * this.posPercentage;
        node.setPos(collision.wirePosToWorldPos(this.wireId.name(), posOnWire));
        return node;
    }

    @Override
    public Optional<ConnectorDataProvider> getConnectorCustomData(WireGraph graph, CustomData customData, WireNode node, int pointIndex) {
        return Optional.of(new CantileverConnectorDataProvider(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f)));
    }

    @Override
    public Vector3f toWorldPos(IWireGraph graph) {
        NewWireCollision collision;
        WireEdge edge = graph.getEdge(this.wireId.id());
        if (graph instanceof WireGraph) {
            WireGraph g = (WireGraph)graph;
            v0 = g.getCollisionById(this.wireId.id()).orElse(null);
        } else if (graph instanceof WireGraphClient) {
            WireGraphClient gc = (WireGraphClient)graph;
            v0 = gc.getCollisionById(this.wireId.id()).orElse(null);
        } else {
            v0 = collision = null;
        }
        if (edge == null || collision == null) {
            return new Vector3f(0.0f);
        }
        float length = collision.length(this.wireId.name());
        float posOnWire = length * this.posPercentage;
        return collision.wirePosToWorldPos(this.wireId.name(), posOnWire);
    }

    @Override
    public boolean validate(WireGraph graph, CompoundTag currentItemData, int pointIndex) {
        return graph.hasEdge(this.wireId.id());
    }

    public boolean equals(Object obj) {
        if (obj instanceof CatenaryWireConnectorNodeData) {
            CatenaryWireConnectorNodeData o = (CatenaryWireConnectorNodeData)obj;
            return this.wireId.equals(o.wireId) && this.posPercentage == o.posPercentage;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.wireId, Float.valueOf(this.posPercentage));
    }
}

