/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph.data.node;

import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.graph.IWireGraph;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.accessor.NodeAccessor;
import de.mrjulsen.wires.graph.data.node.INodeDataBlock;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.graph.data.provider.BasicConnectorDataProvider;
import de.mrjulsen.wires.graph.data.provider.ConnectorDataProvider;
import de.mrjulsen.wires.graph.registry.NodeDataRegistryObject;
import de.mrjulsen.wires.item.CustomData;
import de.mrjulsen.wires.util.Utils;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GenericBlockNodeData
extends NodeData
implements INodeDataBlock {
    private static final String NBT_POS = "Pos";
    private static final String NBT_ATTACH_POINT = "AttachPoint";
    private BlockPos pos;
    private Vector3f attachPoint;

    public GenericBlockNodeData() {
    }

    public GenericBlockNodeData(BlockPos pos, Vector3f attachPoint) {
        this.pos = pos;
        this.attachPoint = attachPoint;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.pos;
    }

    public Vector3f getAttachPoint() {
        return this.attachPoint;
    }

    @Override
    public NodeDataRegistryObject<NodeData, NodeAccessor<NodeData>> getRegistryType() {
        return WiresApi.GENERIC_BLOCK;
    }

    public CompoundTag serializeNbt() {
        CompoundTag nbt = new CompoundTag();
        Utils.putNbtBlockPos(nbt, NBT_POS, this.pos);
        Utils.putNbtVector3f(nbt, NBT_ATTACH_POINT, this.attachPoint);
        return nbt;
    }

    public void deserializeNbt(CompoundTag nbt) {
        this.pos = Utils.getNbtBlockPos(nbt, NBT_POS);
        this.attachPoint = Utils.getNbtVector3f(nbt, NBT_ATTACH_POINT);
    }

    @Override
    public WireNode getOrCreateNode(WireGraph graph) {
        return graph.createNode(this, new Vector3f((float)this.pos.m_123341_(), (float)this.pos.m_123342_(), (float)this.pos.m_123343_()));
    }

    @Override
    public Optional<ConnectorDataProvider> getConnectorCustomData(WireGraph graph, CustomData customData, WireNode node, int pointIndex) {
        return Optional.of(new BasicConnectorDataProvider(new Vector3f((Vector3fc)this.attachPoint)));
    }

    @Override
    public Vector3f toWorldPos(IWireGraph graph) {
        return new Vector3f((float)this.getBlockPos().m_123341_(), (float)this.getBlockPos().m_123342_(), (float)this.getBlockPos().m_123343_()).add((Vector3fc)this.getAttachPoint());
    }

    @Override
    public boolean validate(WireGraph graph, CompoundTag currentItemData, int pointIndex) {
        return !graph.getLevel().m_46749_(this.pos) || !graph.getLevel().m_8055_(this.pos).m_60795_();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GenericBlockNodeData) {
            GenericBlockNodeData o = (GenericBlockNodeData)obj;
            return this.getBlockPos().equals((Object)o.getBlockPos()) && this.getAttachPoint().distance((Vector3fc)o.getAttachPoint()) > 0.25f;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getBlockPos(), this.attachPoint);
    }
}

