/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph.data.node;

import de.mrjulsen.paw.registry.ModBlocks;
import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.graph.IWireGraph;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.graph.data.accessor.NodeAccessor;
import de.mrjulsen.wires.graph.data.node.INodeDataBlock;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.graph.data.provider.ConnectorDataProvider;
import de.mrjulsen.wires.graph.registry.NodeDataRegistryObject;
import de.mrjulsen.wires.item.CustomData;
import de.mrjulsen.wires.util.Utils;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.joml.Vector3f;

public class MastNodeData
extends NodeData
implements INodeDataBlock {
    private static final String NBT_POS = "Pos";
    private BlockPos pos;

    public MastNodeData() {
    }

    public MastNodeData(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.pos;
    }

    @Override
    public NodeDataRegistryObject<NodeData, NodeAccessor<NodeData>> getRegistryType() {
        return WiresApi.MAST;
    }

    public CompoundTag serializeNbt() {
        CompoundTag nbt = new CompoundTag();
        Utils.putNbtBlockPos(nbt, NBT_POS, this.pos);
        return nbt;
    }

    public void deserializeNbt(CompoundTag nbt) {
        this.pos = Utils.getNbtBlockPos(nbt, NBT_POS);
    }

    @Override
    public WireNode getOrCreateNode(WireGraph graph) {
        if (graph.getLevel().m_46749_(this.pos) && graph.getLevel().m_8055_(this.pos).m_204343_().anyMatch(x -> x.equals(ModBlocks.TAG_SUPPORT_WIRE_CONNECTABLE))) {
            return graph.createNode(this, this.getBlockPos().m_252807_().m_252839_());
        }
        return null;
    }

    @Override
    public Optional<ConnectorDataProvider> getConnectorCustomData(WireGraph graph, CustomData customData, WireNode node, int pointIndex) {
        return Optional.of(new ConnectorDataProvider.Empty());
    }

    @Override
    public Vector3f toWorldPos(IWireGraph graph) {
        return new Vector3f((float)this.getBlockPos().m_123341_(), (float)this.getBlockPos().m_123342_(), (float)this.getBlockPos().m_123343_());
    }

    @Override
    public boolean validate(WireGraph graph, CompoundTag currentItemData, int pointIndex) {
        return !graph.getLevel().m_46749_(this.pos) || graph.getLevel().m_8055_(this.pos).m_204343_().anyMatch(x -> x.equals(ModBlocks.TAG_SUPPORT_WIRE_CONNECTABLE));
    }

    public boolean equals(Object obj) {
        if (obj instanceof MastNodeData) {
            MastNodeData o = (MastNodeData)obj;
            return this.getBlockPos().equals((Object)o.getBlockPos());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getBlockPos());
    }
}

