/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph.data.provider;

import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.graph.data.provider.ConnectorDataProvider;
import de.mrjulsen.wires.graph.registry.DLRegistryObject;
import de.mrjulsen.wires.util.Utils;
import net.minecraft.nbt.CompoundTag;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BasicConnectorDataProvider
extends ConnectorDataProvider {
    public static final String NBT_WIRE_ATTACH_POINT = "WireAttachPoint";
    protected Vector3f attachOffset;

    public BasicConnectorDataProvider(Vector3f attachOffset) {
        this.attachOffset = attachOffset;
    }

    public CompoundTag serializeNbt() {
        CompoundTag nbt = new CompoundTag();
        Utils.putNbtVector3f(nbt, NBT_WIRE_ATTACH_POINT, this.attachOffset);
        return nbt;
    }

    public void deserializeNbt(CompoundTag nbt) {
        this.attachOffset = Utils.getNbtVector3f(nbt, NBT_WIRE_ATTACH_POINT);
    }

    @Override
    public DLRegistryObject<ConnectorDataProvider> getRegistryType() {
        return WiresApi.BASIC_WIRE_CONNECTOR;
    }

    public Vector3f getAttachOffset() {
        return new Vector3f((Vector3fc)this.attachOffset);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicConnectorDataProvider) {
            BasicConnectorDataProvider o = (BasicConnectorDataProvider)obj;
            return this.attachOffset.equals((Object)o.attachOffset);
        }
        return false;
    }
}

