/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph.data.provider;

import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.graph.data.provider.BasicConnectorDataProvider;
import de.mrjulsen.wires.graph.data.provider.ConnectorDataProvider;
import de.mrjulsen.wires.graph.registry.DLRegistryObject;
import de.mrjulsen.wires.util.Utils;
import net.minecraft.nbt.CompoundTag;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CantileverConnectorDataProvider
extends BasicConnectorDataProvider {
    public static final String NBT_TENSION_ATTACH_POINT = "TensionWireAttachPoint";
    protected Vector3f tensionWireAttachPoint;

    public CantileverConnectorDataProvider(Vector3f contactWireAttachOffset, Vector3f tensionWireAttachPoint) {
        super(contactWireAttachOffset);
        this.tensionWireAttachPoint = tensionWireAttachPoint;
    }

    @Override
    public CompoundTag serializeNbt() {
        CompoundTag nbt = super.serializeNbt();
        Utils.putNbtVector3f(nbt, NBT_TENSION_ATTACH_POINT, this.tensionWireAttachPoint);
        return nbt;
    }

    @Override
    public void deserializeNbt(CompoundTag nbt) {
        super.deserializeNbt(nbt);
        this.tensionWireAttachPoint = Utils.getNbtVector3f(nbt, NBT_TENSION_ATTACH_POINT);
    }

    @Override
    public DLRegistryObject<ConnectorDataProvider> getRegistryType() {
        return WiresApi.CANTILEVER_WIRE_CONNECTOR;
    }

    public Vector3f getTensionWireAttachOffset() {
        return new Vector3f((Vector3fc)this.tensionWireAttachPoint);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CantileverConnectorDataProvider) {
            CantileverConnectorDataProvider o = (CantileverConnectorDataProvider)obj;
            return super.equals(o) && this.tensionWireAttachPoint.equals((Object)o.tensionWireAttachPoint);
        }
        return false;
    }
}

