/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph.registry;

import de.mrjulsen.wires.graph.data.accessor.NodeAccessor;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.graph.registry.NodeDataRegistryObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public final class NodeDataRegistry {
    private final Map<ResourceLocation, NodeDataRegistryObject<? extends NodeData, ? extends NodeAccessor<?>>> TYPES = new HashMap();

    public <S extends NodeData, B extends NodeAccessor<S>> NodeDataRegistryObject<S, B> register(ResourceLocation id, Supplier<S> factory, Supplier<B> accessor) {
        NodeDataRegistryObject<S, B> type = new NodeDataRegistryObject<S, B>(id, factory, accessor);
        this.TYPES.put(id, type);
        return type;
    }

    private NodeDataRegistryObject<NodeData, NodeAccessor<NodeData>> get(ResourceLocation id) {
        return this.TYPES.get(id);
    }

    public NodeData load(CompoundTag tag) {
        return NodeDataRegistryObject.load(tag, this::get);
    }

    public Collection<NodeDataRegistryObject<? extends NodeData, ? extends NodeAccessor<?>>> getRegisteredTypes() {
        return Collections.unmodifiableCollection(this.TYPES.values());
    }
}

