/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.graph.registry;

import de.mrjulsen.wires.graph.IWireGraph;
import de.mrjulsen.wires.graph.data.accessor.NodeAccessor;
import de.mrjulsen.wires.graph.data.node.NodeData;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public record NodeDataRegistryObject<T extends NodeData, A extends NodeAccessor<T>>(ResourceLocation id, Supplier<T> factory, Supplier<A> accessorFactory) {
    public static final String NBT_ID = "Id";
    public static final String NBT_DATA = "Content";

    public CompoundTag wrap(T data) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(NBT_ID, this.id.toString());
        tag.m_128365_(NBT_DATA, (Tag)data.serializeNbt());
        return tag;
    }

    public T unwrap(CompoundTag tag) {
        T instance = this.create();
        instance.deserializeNbt(tag.m_128469_(NBT_DATA));
        return instance;
    }

    public static <T extends NodeData> T load(CompoundTag tag, Function<ResourceLocation, NodeDataRegistryObject<T, ?>> registryGetter) {
        ResourceLocation typeId = new ResourceLocation(tag.m_128461_(NBT_ID));
        NodeDataRegistryObject<T, ?> type = registryGetter.apply(typeId);
        if (type == null) {
            return null;
        }
        return type.unwrap(tag);
    }

    public T create() {
        return (T)((NodeData)this.factory().get());
    }

    public A createAccessor() {
        return (A)((NodeAccessor)this.accessorFactory().get());
    }

    public Optional<A> getAccessor(IWireGraph graph) {
        return graph.accessNodesOfType(this.id);
    }
}

