/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.item;

import de.mrjulsen.mcdragonlib.data.StatusResult;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.paw.client.gui.widgets.IIconRepresentable;
import de.mrjulsen.paw.client.gui.widgets.ITranslatable;
import de.mrjulsen.paw.item.PAWWireType;
import de.mrjulsen.paw.registry.ModItems;
import de.mrjulsen.wires.IWireType;
import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.graph.registry.IStaticRegisterable;
import de.mrjulsen.wires.item.IWireItemBase;
import de.mrjulsen.wires.item.MultiWireItem;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface IPawWireItemBase
extends IWireItemBase,
IStaticRegisterable<IPawWireItemBase>,
IIconRepresentable,
ITranslatable {
    public static final int WIRE_LENGTH = 400;
    public static final String NBT_WIRE_LENGTH = "WireLength";

    @Override
    default public void removeWireItem(Level level, Player player, InteractionHand hand, HitResult hit, ItemStack stack, int length) {
        if (!player.m_7500_() && !player.m_5833_() && stack.m_41720_() instanceof MultiWireItem) {
            int n;
            IWireType iWireType = this.getWireType(stack);
            if (iWireType instanceof PAWWireType) {
                PAWWireType paw = (PAWWireType)iWireType;
                n = paw.getWireLength(length);
            } else {
                n = length;
            }
            IPawWireItemBase.updateWireAmount(player, stack, -n);
        }
    }

    @Override
    default public StatusResult testPoint(Level level, Player player, InteractionHand hand, HitResult hit, BiConsumer<CompoundTag, CompoundTag> metadata, ItemStack stack, CompoundTag itemData, CompoundTag customDataNbt, List<CompoundTag> points, NodeData nodeData) {
        StatusResult result = IWireItemBase.super.testPoint(level, player, hand, hit, metadata, stack, itemData, customDataNbt, points, nodeData);
        if (!result.result()) {
            return result;
        }
        WireGraph graph = WireGraphManager.get(level, this.getWireType(stack).getGraphId(itemData));
        if (!points.isEmpty()) {
            PAWWireType paw;
            NodeData previousNode = WiresApi.NODE_DATA_REGISTRY.load(points.get(points.size() - 1));
            int distance = (int)previousNode.toWorldPos(graph).distance((Vector3fc)nodeData.toWorldPos(graph));
            IWireType iWireType = this.getWireType(stack);
            if (iWireType instanceof PAWWireType && (paw = (PAWWireType)iWireType).getWireLength(distance) > IPawWireItemBase.getRemainingWire(stack)) {
                return new StatusResult(false, 0, "item.pantographsandwires.wire.not_enough_wire");
            }
        }
        return result;
    }

    public static int getRemainingWire(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return nbt.m_128441_(NBT_WIRE_LENGTH) ? nbt.m_128451_(NBT_WIRE_LENGTH) : 400;
    }

    default public int getConextRemainingWire(ItemStack stack) {
        int n;
        IWireType iWireType = this.getWireType(stack);
        if (iWireType instanceof PAWWireType) {
            PAWWireType paw = (PAWWireType)iWireType;
            n = paw.getWireLength(IPawWireItemBase.getRemainingWire(stack));
        } else {
            n = 0;
        }
        return n;
    }

    public static int updateWireAmount(Player player, ItemStack stack, int length) {
        CompoundTag nbt = stack.m_41784_();
        int current = IPawWireItemBase.getRemainingWire(stack);
        int newValue = current + length;
        int cleanValue = MathUtils.clamp((int)newValue, (int)0, (int)400);
        if (newValue <= 0) {
            if (player == null || !player.m_7500_() && !player.m_5833_()) {
                stack.m_41774_(1);
            }
            player.m_150109_().m_36054_(ModItems.EMPTY_WIRE_COIL.asStack());
        } else {
            nbt.m_128405_(NBT_WIRE_LENGTH, cleanValue);
            stack.m_41751_(nbt);
        }
        return newValue - cleanValue;
    }

    public static void setWireAmount(Player player, ItemStack stack, int newValue) {
        CompoundTag nbt = stack.m_41784_();
        if (newValue <= 0) {
            if (player == null || !player.m_7500_() && !player.m_5833_()) {
                stack.m_41774_(1);
            }
            player.m_150109_().m_36054_(ModItems.EMPTY_WIRE_COIL.asStack());
        } else {
            nbt.m_128405_(NBT_WIRE_LENGTH, newValue);
            stack.m_41751_(nbt);
        }
    }

    @Override
    default public Component createHudInfoText(ItemStack stack, Player player, HitResult hit) {
        int distance;
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("ConnectionData")) {
            return null;
        }
        CompoundTag itemData = IWireItemBase.getNbt(stack);
        ListTag list = itemData.m_128437_("CustomPointData", 10);
        WireGraphClient graph = WireGraphManager.getClient(player.m_9236_(), this.getWireType(stack).getGraphId(itemData));
        if (graph == null || list.isEmpty()) {
            return null;
        }
        CompoundTag lastPointData = (CompoundTag)list.get(list.size() - 1);
        NodeData node = WiresApi.NODE_DATA_REGISTRY.load(lastPointData);
        Vector3f pos = node.toWorldPos(graph);
        int maxLength = this.getWireType(stack).getMaxLength();
        int availableLength = this.getConextRemainingWire(stack);
        if (hit instanceof BlockHitResult) {
            BlockHitResult r = (BlockHitResult)hit;
            distance = (int)pos.distance((Vector3fc)r.m_82450_().m_252839_());
        } else {
            distance = (int)pos.distance((Vector3fc)player.m_146892_().m_252839_());
        }
        MutableComponent text = TextUtils.empty().m_130940_(ChatFormatting.WHITE).m_7220_((Component)TextUtils.text((String)String.format("X: %s, Y: %s, Z: %s", (int)pos.x(), (int)pos.y(), (int)pos.z())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)" \u25a0 ").m_130940_(ChatFormatting.GRAY));
        if (availableLength < maxLength) {
            int ml = Math.min(maxLength, availableLength);
            text = text.m_7220_((Component)TextUtils.text((String)String.format("%sm / ", distance)).m_130940_(distance == ml ? ChatFormatting.GOLD : (distance < ml ? ChatFormatting.GREEN : ChatFormatting.RED))).m_7220_((Component)TextUtils.text((String)String.format("%sm", maxLength)).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.STRIKETHROUGH)).m_7220_((Component)TextUtils.text((String)String.format(" %sm", availableLength)).m_130940_(distance == ml ? ChatFormatting.GOLD : (distance < ml ? ChatFormatting.GREEN : ChatFormatting.RED)));
        } else {
            text = text.m_130946_(String.format("%sm / %sm", distance, this.getWireType(stack).getMaxLength())).m_130940_(distance == maxLength ? ChatFormatting.GOLD : (distance < maxLength ? ChatFormatting.GREEN : ChatFormatting.RED));
        }
        return text;
    }

    public static boolean creditWireToInventory(Player player, int amount) {
        boolean offhandFull;
        MutableInt remaining = new MutableInt(amount);
        int inventorySize = player.m_150109_().m_6643_();
        LinkedBlockingDeque<ItemStack> wireCoilStacks = new LinkedBlockingDeque<ItemStack>(inventorySize);
        int freeSlots = 0;
        int availableEmptyCoils = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_()) {
                ++freeSlots;
                continue;
            }
            if (ModItems.EMPTY_WIRE_COIL.is(stack.m_41720_())) {
                availableEmptyCoils += stack.m_41613_();
                continue;
            }
            if (!ModItems.WIRE.is(stack.m_41720_()) || IPawWireItemBase.getRemainingWire(stack) >= 400) continue;
            wireCoilStacks.add(stack);
        }
        boolean mainHandFull = IPawWireItemBase.getRemainingWire(player.m_21205_()) >= 400;
        boolean bl = offhandFull = IPawWireItemBase.getRemainingWire(player.m_21206_()) >= 400;
        while (!(remaining.intValue() <= 0 || mainHandFull && offhandFull && wireCoilStacks.isEmpty() && (availableEmptyCoils <= 0 || freeSlots <= 0))) {
            int d;
            ItemStack stack;
            if (!mainHandFull) {
                stack = player.m_21205_();
                d = IPawWireItemBase.updateWireAmount(player, stack, remaining.intValue());
                remaining.setValue(d);
                mainHandFull |= d > 0;
                continue;
            }
            if (!offhandFull) {
                stack = player.m_21206_();
                d = IPawWireItemBase.updateWireAmount(player, stack, remaining.intValue());
                remaining.setValue(d);
                offhandFull |= d > 0;
                continue;
            }
            if (!wireCoilStacks.isEmpty()) {
                stack = (ItemStack)wireCoilStacks.peek();
                d = IPawWireItemBase.updateWireAmount(player, stack, remaining.intValue());
                remaining.setValue(d);
                wireCoilStacks.remove();
                continue;
            }
            stack = ModItems.WIRE.asStack();
            int a = Math.min(remaining.intValue(), 400);
            IPawWireItemBase.setWireAmount(player, stack, a);
            remaining.subtract(a);
            player.m_150109_().m_36054_(stack);
            player.m_150109_().m_36022_(x -> x.m_150930_((Item)ModItems.EMPTY_WIRE_COIL.get()), 1, (Container)player.f_36095_.m_39730_());
            --freeSlots;
            --availableEmptyCoils;
        }
        return remaining.intValue() <= 0;
    }
}

