/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.item;

import de.mrjulsen.mcdragonlib.data.StatusResult;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.paw.data.WireHitResult;
import de.mrjulsen.wires.IWireType;
import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.graph.data.node.NodeData;
import de.mrjulsen.wires.item.CustomData;
import de.mrjulsen.wires.item.IWireInteractableItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface IWireItemBase
extends IWireInteractableItem {
    public static final String NBT_ROOT = "ConnectionData";
    public static final String NBT_POINTS = "CustomPointData";
    public static final String NBT_CONNECTOR_TYPE = "ConnectorType";
    public static final String NBT_POS = "Pos";
    public static final String NBT_WIRE_ID = "WireId";
    public static final String NBT_CUSTOM_DATA = "CustomData";
    public static final String NBT_TOTAL_POINTS_COUNT = "PointsCount";

    public IWireType getWireType(ItemStack var1);

    default public IWireItemBase getActor(ItemStack stack) {
        return this;
    }

    default public InteractionResultHolder<ItemStack> useWire(Level level, Player player, InteractionHand usedHand) {
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(usedHand));
    }

    default public InteractionResult useWireOn(UseOnContext context) {
        return this.placeWire(context.m_43725_(), context.m_43723_(), context.m_43724_(), (HitResult)new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_()), null);
    }

    @Override
    default public InteractionResult interactWithWire(Level level, Player player, InteractionHand hand, WireHitResult hit) {
        return this.placeWire(level, player, hand, hit, null);
    }

    default public boolean addNewPoint(Level level, Player player, InteractionHand hand, HitResult hit, BiConsumer<CompoundTag, CompoundTag> metadata, ItemStack stack, CompoundTag itemData, CompoundTag customDataNbt, List<CompoundTag> points) {
        NodeData data = this.createNodeData(level, player, hand, hit);
        if (data == null) {
            return false;
        }
        StatusResult testResult = this.testPoint(level, player, hand, hit, metadata, stack, itemData, customDataNbt, points, data);
        if (!testResult.result()) {
            player.m_5661_((Component)TextUtils.translate((String)testResult.message(), (Object[])new Object[]{this.getWireType(stack).getMaxLength()}).m_130940_(ChatFormatting.RED), true);
            IWireItemBase.clear(stack);
            return false;
        }
        CompoundTag nodeMeta = new CompoundTag();
        DLUtils.doIfNotNull(metadata, x -> x.accept(customDataNbt, nodeMeta));
        CompoundTag nodeData = data.getRegistryType().wrap(data);
        nodeData.m_128365_(NBT_CUSTOM_DATA, (Tag)nodeMeta);
        points.add(nodeData);
        return true;
    }

    default public StatusResult testPoint(Level level, Player player, InteractionHand hand, HitResult hit, BiConsumer<CompoundTag, CompoundTag> metadata, ItemStack stack, CompoundTag itemData, CompoundTag customDataNbt, List<CompoundTag> points, NodeData nodeData) {
        WireGraph graph = WireGraphManager.get(level, this.getWireType(stack).getGraphId(itemData));
        if (!points.isEmpty()) {
            NodeData previousNode = WiresApi.NODE_DATA_REGISTRY.load(points.get(points.size() - 1));
            if (previousNode.toWorldPos(graph).distance((Vector3fc)nodeData.toWorldPos(graph)) > (float)this.getWireType(stack).getMaxLength()) {
                return new StatusResult(false, 0, "item.wiresapi.wire.to_far_away");
            }
            if (previousNode.equals(nodeData)) {
                return new StatusResult(false, 0, "item.wiresapi.wire.same_connector");
            }
        }
        if (!nodeData.validate(graph, itemData, points.size())) {
            return new StatusResult(false, 0, "item.wiresapi.wire.connector_invalid");
        }
        return new StatusResult(true, 0, "");
    }

    default public boolean canCreateWire(Level level, Player player, InteractionHand hand, HitResult hit, ItemStack stack, CompoundTag itemData, CompoundTag customDataNbt, List<CompoundTag> points) {
        return points.size() >= 2;
    }

    default public WireGraph.CreateEdgeResult createWire(Level level, Player player, InteractionHand hand, HitResult hit, ItemStack stack, CompoundTag itemData, CompoundTag customDataNbt, List<CompoundTag> points) {
        WireGraph graph = WireGraphManager.get(level, this.getWireType(stack).getGraphId(itemData));
        ArrayList<NodeData> deserializedData = new ArrayList<NodeData>(points.size());
        CompoundTag pointsMeta = new CompoundTag();
        for (int i = 0; i < points.size(); ++i) {
            CompoundTag nodeNbt = points.get(i);
            pointsMeta.m_128365_(String.valueOf(i), (Tag)nodeNbt.m_128469_(NBT_CUSTOM_DATA));
            deserializedData.add(WiresApi.NODE_DATA_REGISTRY.load(nodeNbt));
        }
        CompoundTag metaCollection = new CompoundTag();
        if (!customDataNbt.m_128456_()) {
            metaCollection.m_128365_(NBT_CUSTOM_DATA, (Tag)customDataNbt);
        }
        if (!pointsMeta.m_128456_()) {
            metaCollection.m_128365_(NBT_POINTS, (Tag)pointsMeta);
        }
        metaCollection.m_128405_(NBT_TOTAL_POINTS_COUNT, points.size());
        MutableInt idx = new MutableInt();
        WireGraph.CreateEdgeResult result = graph.createEdge(this.getWireType(stack), new CustomData(metaCollection), (NodeData)deserializedData.get(0), (NodeData)deserializedData.get(1), idx, true);
        if (!result.success()) {
            String key = switch (result.code()) {
                case 0 -> "item.wiresapi.wire.connection_already_exists";
                case 1 -> "item.wiresapi.wire.connector_invalid";
                default -> "";
            };
            player.m_5661_((Component)TextUtils.translate((String)key).m_130940_(ChatFormatting.RED), true);
        }
        IWireItemBase.clear(stack);
        return result;
    }

    default public void removeWireItem(Level level, Player player, InteractionHand hand, HitResult hit, ItemStack stack, int length) {
        if (player == null || !player.m_7500_() && !player.m_5833_()) {
            stack.m_41774_(1);
        }
    }

    default public InteractionResult placeWire(Level level, Player player, InteractionHand hand, HitResult hit, BiConsumer<CompoundTag, CompoundTag> metadata) {
        WireGraph.CreateEdgeResult result;
        if (level.m_5776_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!(stack.m_41720_() instanceof IWireItemBase)) {
            return InteractionResult.FAIL;
        }
        CompoundTag itemData = IWireItemBase.getNbt(stack);
        CompoundTag customDataNbt = itemData.m_128469_(NBT_CUSTOM_DATA);
        ArrayList<CompoundTag> points = new ArrayList<CompoundTag>();
        if (itemData.m_128441_(NBT_POINTS)) {
            points.addAll(itemData.m_128437_(NBT_POINTS, 10).stream().map(x -> (CompoundTag)x).toList());
        }
        if (!this.addNewPoint(level, player, hand, hit, metadata, stack, itemData, customDataNbt, points)) {
            return InteractionResult.FAIL;
        }
        ListTag pointsList = new ListTag();
        for (CompoundTag p : points) {
            pointsList.add((Object)p);
        }
        itemData.m_128365_(NBT_POINTS, (Tag)pointsList);
        itemData.m_128365_(NBT_CUSTOM_DATA, (Tag)customDataNbt);
        IWireItemBase.setNbt(stack, itemData);
        if (this.canCreateWire(level, player, hand, hit, stack, itemData, customDataNbt, points) && (result = this.createWire(level, player, hand, hit, stack, itemData, customDataNbt, points)).success()) {
            this.removeWireItem(level, player, hand, hit, stack, result.edge().get().length());
        }
        return InteractionResult.SUCCESS;
    }

    default public NodeData createNodeData(Level level, Player player, InteractionHand hand, HitResult hit) {
        return null;
    }

    default public Component createHudInfoText(ItemStack stack, Player player, HitResult hit) {
        int distance;
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(NBT_ROOT)) {
            return null;
        }
        CompoundTag itemData = IWireItemBase.getNbt(stack);
        ListTag list = itemData.m_128437_(NBT_POINTS, 10);
        WireGraphClient graph = WireGraphManager.getClient(player.m_9236_(), this.getWireType(stack).getGraphId(itemData));
        if (graph == null || list.isEmpty()) {
            return null;
        }
        CompoundTag lastPointData = (CompoundTag)list.get(list.size() - 1);
        NodeData node = WiresApi.NODE_DATA_REGISTRY.load(lastPointData);
        Vector3f pos = node.toWorldPos(graph);
        int maxLength = this.getWireType(stack).getMaxLength();
        if (hit instanceof BlockHitResult) {
            BlockHitResult r = (BlockHitResult)hit;
            distance = (int)pos.distance((Vector3fc)r.m_82450_().m_252839_());
        } else {
            distance = (int)pos.distance((Vector3fc)player.m_146892_().m_252839_());
        }
        return TextUtils.empty().m_130940_(ChatFormatting.WHITE).m_7220_((Component)TextUtils.text((String)String.format("X: %s, Y: %s, Z: %s", (int)pos.x(), (int)pos.y(), (int)pos.z())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)TextUtils.text((String)" \u25a0 ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)TextUtils.text((String)String.format("%sm / %sm", distance, this.getWireType(stack).getMaxLength())).m_130940_(distance == maxLength ? ChatFormatting.GOLD : (distance < maxLength ? ChatFormatting.GREEN : ChatFormatting.RED)));
    }

    public static CompoundTag getNbt(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        CompoundTag root = !nbt.m_128441_(NBT_ROOT) ? new CompoundTag() : nbt.m_128469_(NBT_ROOT);
        if (!root.m_128441_(NBT_POINTS)) {
            root.m_128365_(NBT_POINTS, (Tag)new ListTag());
        }
        nbt.m_128365_(NBT_ROOT, (Tag)root);
        return root;
    }

    public static void setNbt(ItemStack stack, CompoundTag nbt) {
        CompoundTag itemNbt = stack.m_41784_();
        itemNbt.m_128365_(NBT_ROOT, (Tag)nbt);
        stack.m_41751_(itemNbt);
    }

    public static void clear(ItemStack stack) {
        stack.m_41784_().m_128473_(NBT_ROOT);
    }
}

