/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.item;

import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.paw.data.WireHitResult;
import de.mrjulsen.paw.data.WireSettingsData;
import de.mrjulsen.paw.event.ClientWrapper;
import de.mrjulsen.paw.registry.ModWireRegistry;
import de.mrjulsen.wires.IWireType;
import de.mrjulsen.wires.item.AbstractWireItemBase;
import de.mrjulsen.wires.item.IPawWireItemBase;
import de.mrjulsen.wires.item.IWireItemBase;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class MultiWireItem
extends AbstractWireItemBase {
    public static final String NBT_TYPE = "SelectedSubtype";

    public MultiWireItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Override
    public IWireType getWireType(ItemStack stack) {
        return this.getSubType(stack).getWireType(stack);
    }

    public IWireItemBase getSubType(ItemStack stack) {
        IPawWireItemBase type = ModWireRegistry.WIRE_SUBTYPES_REGISTRY.load(stack.m_41784_().m_128469_(NBT_TYPE));
        return type == null ? (IWireItemBase)ModWireRegistry.ENERGY_WIRE_ITEM_SUBTYPE.get() : type;
    }

    @Override
    public InteractionResult interactWithWire(Level level, Player player, InteractionHand hand, WireHitResult hit) {
        return this.getSubType(player.m_21120_(hand)).interactWithWire(level, player, hand, hit);
    }

    @Override
    public InteractionResult m_6225_(UseOnContext context) {
        return this.getSubType(context.m_43722_()).useWireOn(context);
    }

    public static boolean setNbt(ItemStack stack, WireSettingsData data) {
        if (stack.m_41720_() instanceof MultiWireItem) {
            data.toNbt(stack.m_41784_());
            return true;
        }
        return false;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (level.f_46443_ && player.m_6144_()) {
            ClientWrapper.showWireTypeSelectionScreen(player.m_21120_(usedHand));
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(usedHand));
        }
        IPawWireItemBase item = (IPawWireItemBase)this.getSubType(player.m_21120_(usedHand));
        return item.useWire(level, player, usedHand);
    }

    @Override
    public Component createHudInfoText(ItemStack stack, Player player, HitResult hit) {
        return this.getSubType(stack).createHudInfoText(stack, player, hit);
    }

    public void m_7373_(ItemStack stack, Level player, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, player, list, flag);
        list.add((Component)TextUtils.text((String)"Type: ").m_7220_((Component)TextUtils.translate((String)((IPawWireItemBase)this.getSubType(stack)).getTranslationKey())));
        list.add((Component)TextUtils.text((String)("Amount: " + IPawWireItemBase.getRemainingWire(stack) + "m")));
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return IPawWireItemBase.getRemainingWire(stack) * 13 / 400;
    }

    public int m_142159_(ItemStack pStack) {
        return -65536;
    }
}

