/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.network;

import de.mrjulsen.wires.util.GraphId;
import de.mrjulsen.wires.util.Utils;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;

public record WireChunkUnloadingData(GraphId id, ChunkPos pos, Collection<UUID> connections) {
    private static final String NBT_GRAPH_ID = "GraphId";
    private static final String NBT_CHUNK = "Chunk";
    private static final String NBT_ID = "Id";

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag ids = new ListTag();
        ids.addAll(this.connections.stream().map(x -> StringTag.m_129297_((String)x.toString())).toList());
        nbt.m_128359_(NBT_GRAPH_ID, this.id.id());
        nbt.m_128365_(NBT_ID, (Tag)ids);
        Utils.putNbtChunkPos(nbt, NBT_CHUNK, this.pos);
        return nbt;
    }

    public static WireChunkUnloadingData fromNbt(CompoundTag nbt) {
        return new WireChunkUnloadingData(new GraphId(nbt.m_128461_(NBT_GRAPH_ID)), Utils.getNbtChunkPos(nbt, NBT_CHUNK), nbt.m_128437_(NBT_ID, 8).stream().map(x -> UUID.fromString(x.m_7916_())).collect(Collectors.toSet()));
    }
}

