/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.network;

import de.mrjulsen.wires.WireConnection;
import de.mrjulsen.wires.decoration.WireDecorationData;
import de.mrjulsen.wires.util.Utils;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public class WireConnectionSyncData {
    private static final String NBT_CONNECTION_ID = "Id";
    private static final String NBT_BLOCK_START = "StartBlock";
    private static final String NBT_BLOCK_END = "EndBlock";
    private static final String NBT_START = "Start";
    private static final String NBT_END = "End";
    private static final String NBT_WIRE_TYPE = "WireType";
    private static final String NBT_CONNECTOR_A_DATA = "ConnectorA";
    private static final String NBT_CONNECTOR_B_DATA = "ConnectorB";
    private static final String NBT_CREATION_DATA = "CreationData";
    private static final String NBT_DECORATIONS = "Decorations";
    private static final String NBT_ORIGIN_CHUNK_SECTION = "OriginChunkSection";
    private final UUID connectionId;
    private final Vector3f startPos;
    private final Vector3f endPos;
    private final BlockPos startBlockPos;
    private final BlockPos endBlockPos;
    private final ResourceLocation wireType;
    private final CompoundTag connectorAData;
    private final CompoundTag connectorBData;
    private final CompoundTag customData;
    private final SectionPos originChunkSection;
    private final Collection<WireDecorationData> decorations;

    public WireConnectionSyncData(UUID connectionId, BlockPos startBlockPos, BlockPos endBlockPos, Vector3f startPos, Vector3f endPos, ResourceLocation wireType, CompoundTag connectorAData, CompoundTag connectorBData, CompoundTag customData, SectionPos originChunkSection, Collection<WireDecorationData> decorations) {
        this.connectionId = connectionId;
        this.startBlockPos = startBlockPos;
        this.endBlockPos = endBlockPos;
        this.startPos = startPos;
        this.endPos = endPos;
        this.wireType = wireType;
        this.connectorAData = connectorAData;
        this.connectorBData = connectorBData;
        this.customData = customData;
        this.originChunkSection = originChunkSection;
        this.decorations = decorations;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_(NBT_CONNECTION_ID, this.connectionId);
        Utils.putNbtBlockPos(nbt, NBT_BLOCK_START, this.startBlockPos);
        Utils.putNbtBlockPos(nbt, NBT_BLOCK_END, this.endBlockPos);
        Utils.putNbtVector3f(nbt, NBT_START, this.startPos);
        Utils.putNbtVector3f(nbt, NBT_END, this.endPos);
        nbt.m_128359_(NBT_WIRE_TYPE, this.wireType.toString());
        nbt.m_128365_(NBT_CONNECTOR_A_DATA, (Tag)this.connectorAData);
        nbt.m_128365_(NBT_CONNECTOR_B_DATA, (Tag)this.connectorBData);
        nbt.m_128365_(NBT_CREATION_DATA, (Tag)this.customData);
        Utils.putNbtSectionPos(nbt, NBT_ORIGIN_CHUNK_SECTION, this.originChunkSection);
        ListTag decoList = new ListTag();
        for (WireDecorationData deco : this.decorations) {
            decoList.add((Object)deco.toNbt());
        }
        nbt.m_128365_(NBT_DECORATIONS, (Tag)decoList);
        return nbt;
    }

    public static WireConnectionSyncData fromNbt(CompoundTag nbt) {
        return new WireConnectionSyncData(nbt.m_128342_(NBT_CONNECTION_ID), Utils.getNbtBlockPos(nbt, NBT_BLOCK_START), Utils.getNbtBlockPos(nbt, NBT_BLOCK_END), Utils.getNbtVector3f(nbt, NBT_START), Utils.getNbtVector3f(nbt, NBT_END), Utils.resLoc(nbt.m_128461_(NBT_WIRE_TYPE)), nbt.m_128469_(NBT_CONNECTOR_A_DATA), nbt.m_128469_(NBT_CONNECTOR_B_DATA), nbt.m_128469_(NBT_CREATION_DATA), Utils.getNbtSectionPos(nbt, NBT_ORIGIN_CHUNK_SECTION), nbt.m_128437_(NBT_DECORATIONS, 10).stream().map(x -> WireDecorationData.fromNbt((CompoundTag)x)).toList());
    }

    public static WireConnectionSyncData of(WireConnection wireConnection) {
        return new WireConnectionSyncData(wireConnection.getId(), wireConnection.getPointA(), wireConnection.getPointB(), wireConnection.getRelativeStart(), wireConnection.getRelativeEnd(), wireConnection.getWireType().getRegistryId(), wireConnection.getConnectionANbt(), wireConnection.getConnectionBNbt(), wireConnection.getCustomData(), wireConnection.originChunkSection(), wireConnection.getDecorations());
    }

    public UUID getConnectionId() {
        return this.connectionId;
    }

    public Vector3f getStartPos() {
        return this.startPos;
    }

    public Vector3f getEndPos() {
        return this.endPos;
    }

    public BlockPos getStartBlockPos() {
        return this.startBlockPos;
    }

    public BlockPos getEndBlockPos() {
        return this.endBlockPos;
    }

    public ResourceLocation getWireType() {
        return this.wireType;
    }

    public CompoundTag getConnectorAData() {
        return this.connectorAData;
    }

    public CompoundTag getConnectorBData() {
        return this.connectorBData;
    }

    public CompoundTag getCustomData() {
        return this.customData;
    }

    public SectionPos getOriginChunkSection() {
        return this.originChunkSection;
    }

    public Collection<WireDecorationData> getDecorations() {
        return this.decorations;
    }

    public Vector3f getWireAttachPointA() {
        return Utils.getNbtVector3f(this.getConnectorAData(), "WireAttachPoint");
    }

    public Vector3f getWireAttachPointB() {
        return Utils.getNbtVector3f(this.getConnectorBData(), "WireAttachPoint");
    }
}

