/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.network;

import de.mrjulsen.paw.util.collision.LineShape;
import de.mrjulsen.paw.util.collision.RaycastHitResult;
import de.mrjulsen.wires.IWireType;
import de.mrjulsen.wires.WireTypeRegistry;
import de.mrjulsen.wires.graph.NewWireCollision;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireGraphManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record WireId(UUID id, String name, IWireType type) {
    private static final String NBT_ID = "Id";
    private static final String NBT_NAME = "Name";
    private static final String NBT_TYPE = "Type";

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_(NBT_ID, this.id);
        nbt.m_128359_(NBT_NAME, this.name);
        nbt.m_128359_(NBT_TYPE, this.type.getRegistryId().toString());
        return nbt;
    }

    public static Optional<WireId> fromNbt(CompoundTag nbt) {
        ResourceLocation type = new ResourceLocation(nbt.m_128461_(NBT_TYPE));
        if (!WireTypeRegistry.has(type)) {
            return Optional.empty();
        }
        return Optional.of(new WireId(nbt.m_128342_(NBT_ID), nbt.m_128461_(NBT_NAME), WireTypeRegistry.get(type)));
    }

    public static Optional<RaycastHitResult> checkCollision(Level lvl, BlockPos pos, Vector3f rayOrigin, Vector3f rayDirection) {
        RaycastHitResult hit = null;
        for (WireGraphClient graph : WireGraphManager.getAllClient(lvl)) {
            Collection<NewWireCollision> collisions = graph.getCollisionsInBlock(pos);
            ArrayList<NewWireCollision.WireBlockCollision> collisionsinBlock = new ArrayList<NewWireCollision.WireBlockCollision>();
            for (NewWireCollision newWireCollision : collisions) {
                collisionsinBlock.addAll(Collections.synchronizedCollection(newWireCollision.collisionsInBlock(pos)));
            }
            for (NewWireCollision.WireBlockCollision wireBlockCollision : collisionsinBlock) {
                Vector3f b;
                Vector3f a = new Vector3f((Vector3fc)wireBlockCollision.getInVector()).add((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                LineShape wire = new LineShape(a, b = new Vector3f((Vector3fc)wireBlockCollision.getOutVector()).add((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_()), 0.125f);
                Optional<RaycastHitResult> res = wire.intersects(rayOrigin, rayDirection).map(h -> new RaycastHitResult(new Vec3(h), pos, new Vector3f((Vector3fc)h).sub((Vector3fc)rayOrigin).length(), wireBlockCollision));
                if (!res.isPresent() || hit != null && !(hit.getDistance() < res.get().getDistance())) continue;
                hit = res.get();
            }
        }
        return Optional.ofNullable(hit);
    }
}

