/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.network;

import de.mrjulsen.wires.graph.WireEdge;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.util.GraphId;
import de.mrjulsen.wires.util.Utils;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public record WiresSyncData(GraphId id, @Nullable ChunkPos pos, Supplier<Collection<WireEdge>> edges, Supplier<Collection<WireNode>> nodes, boolean forceUpdate) {
    private static final String NBT_GRAPH_ID = "GraphId";
    private static final String NBT_CHUNK = "Chunk";
    private static final String NBT_NODES = "Nodes";
    private static final String NBT_EDGES = "Edges";
    private static final String NBT_FORCE_UPDATE = "ForceUpdate";

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        if (this.pos != null) {
            Utils.putNbtChunkPos(nbt, NBT_CHUNK, this.pos);
        }
        ListTag edgesList = new ListTag();
        for (WireEdge edge : this.edges.get()) {
            edgesList.add((Object)edge.toNbt());
        }
        ListTag nodesList = new ListTag();
        for (WireNode node : this.nodes.get()) {
            if (node == null) continue;
            nodesList.add((Object)node.toNbt());
        }
        nbt.m_128359_(NBT_GRAPH_ID, this.id.id());
        nbt.m_128365_(NBT_EDGES, (Tag)edgesList);
        nbt.m_128365_(NBT_NODES, (Tag)nodesList);
        nbt.m_128379_(NBT_FORCE_UPDATE, this.forceUpdate);
        return nbt;
    }

    public static WiresSyncData fromNbt(Level level, CompoundTag nbt) {
        GraphId id = new GraphId(nbt.m_128461_(NBT_GRAPH_ID));
        WireGraphClient graph = WireGraphManager.getClient(level, id);
        return new WiresSyncData(id, nbt.m_128441_(NBT_CHUNK) ? Utils.getNbtChunkPos(nbt, NBT_CHUNK) : null, () -> nbt.m_128437_(NBT_EDGES, 10).stream().map(x -> WireEdge.fromNbt(graph, (CompoundTag)x).orElse(null)).toList(), () -> nbt.m_128437_(NBT_NODES, 10).stream().map(x -> WireNode.fromNbt(graph, (CompoundTag)x).orElse(null)).toList(), nbt.m_128471_(NBT_FORCE_UPDATE));
    }

    public static class Wrapper {
        private final CompoundTag nbt;

        public Wrapper(WiresSyncData data) {
            this(data.toNbt());
        }

        private Wrapper(CompoundTag nbt) {
            this.nbt = nbt;
        }

        public CompoundTag toNbt() {
            return this.nbt;
        }

        public static Wrapper fromNbt(CompoundTag nbt) {
            return new Wrapper(nbt);
        }

        public WiresSyncData unwrap(Level level) {
            return WiresSyncData.fromNbt(level, this.nbt);
        }
    }
}

