/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.network.packets.stc;

import de.mrjulsen.mcdragonlib.net.IPacketBase;
import de.mrjulsen.paw.PantographsAndWires;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.network.DeleteWireSyncData;
import de.mrjulsen.wires.util.ClientUtils;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;

public class DeleteWireConnectionPacket
implements IPacketBase<DeleteWireConnectionPacket> {
    private DeleteWireSyncData data;

    public DeleteWireConnectionPacket() {
    }

    public DeleteWireConnectionPacket(DeleteWireSyncData data) {
        this.data = data;
    }

    public void encode(DeleteWireConnectionPacket packet, FriendlyByteBuf buf) {
        buf.m_130079_(packet.data.toNbt());
    }

    public DeleteWireConnectionPacket decode(FriendlyByteBuf buf) {
        return new DeleteWireConnectionPacket(DeleteWireSyncData.fromNbt(buf.m_130260_()));
    }

    public void handle(DeleteWireConnectionPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            try {
                WireGraphClient graph = WireGraphManager.getClient(ClientUtils.level(), packet.data.id());
                for (UUID id : packet.data.wireEdgeIds()) {
                    graph.removeEdge(id);
                }
            }
            catch (Exception e) {
                PantographsAndWires.LOGGER.error("Unable to process DeleteWireConnectionPacket:", (Throwable)e);
            }
        }));
    }
}

