/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.network.packets.stc;

import de.mrjulsen.mcdragonlib.net.IPacketBase;
import de.mrjulsen.paw.PantographsAndWires;
import de.mrjulsen.wires.graph.WireEdge;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.graph.WireNode;
import de.mrjulsen.wires.network.WiresSyncData;
import de.mrjulsen.wires.util.ClientUtils;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;

public class WireConnectorDataPacket
implements IPacketBase<WireConnectorDataPacket> {
    private WiresSyncData.Wrapper data;

    public WireConnectorDataPacket() {
    }

    public WireConnectorDataPacket(WiresSyncData.Wrapper data) {
        this.data = data;
    }

    public void encode(WireConnectorDataPacket packet, FriendlyByteBuf buf) {
        buf.m_130079_(packet.data.toNbt());
    }

    public WireConnectorDataPacket decode(FriendlyByteBuf buf) {
        return new WireConnectorDataPacket(WiresSyncData.Wrapper.fromNbt(buf.m_130260_()));
    }

    public void handle(WireConnectorDataPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            try {
                WiresSyncData d = packet.data.unwrap(ClientUtils.level());
                WireGraphClient graph = WireGraphManager.getClient(ClientUtils.level(), d.id());
                for (WireNode node : d.nodes().get()) {
                    if (node == null) continue;
                    graph.addNode(node);
                }
                for (WireEdge edge : d.edges().get()) {
                    if (edge == null) continue;
                    graph.addEdge(edge, d.forceUpdate());
                }
            }
            catch (Exception e) {
                PantographsAndWires.LOGGER.error("Unable to process WireConnectorDataPacket:", (Throwable)e);
            }
        }));
    }
}

