/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.render;

import de.mrjulsen.wires.decoration.WireDecorationData;
import de.mrjulsen.wires.render.WireRenderPoint;
import de.mrjulsen.wires.render.WireSegmentRenderData;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import org.joml.Vector3f;

public class WireRenderData {
    private final WireRenderPoint[] points;

    public WireRenderData(int size) {
        this.points = new WireRenderPoint[size];
    }

    public void setPoint(WireRenderPoint point, int index) {
        this.points[index] = point;
    }

    public WireRenderPoint getPoint(int index) {
        return this.points[index];
    }

    public int count() {
        return this.points.length;
    }

    public Map<SectionPos, WireSegmentRenderData> splitInChunkSections(TreeMap<Float, WireDecorationData> decorations) {
        LinkedHashMap<SectionPos, WireSegmentRenderData> result = new LinkedHashMap<SectionPos, WireSegmentRenderData>();
        Vector3f v = this.points[0].vertex(WireRenderPoint.VertexCorner.CENTER);
        SectionPos lastSection = SectionPos.m_123199_((BlockPos)new BlockPos((int)v.x, (int)v.y, (int)v.z));
        WireRenderPoint lastVertices = this.points[0].offset(lastSection);
        result.computeIfAbsent(lastSection, x -> new WireSegmentRenderData()).add(lastVertices);
        for (int i = 1; i < this.points.length; ++i) {
            v = this.points[i].vertex(WireRenderPoint.VertexCorner.CENTER);
            SectionPos section = SectionPos.m_123199_((BlockPos)new BlockPos((int)v.x, (int)v.y, (int)v.z));
            WireRenderPoint vertices = this.points[i].offset(section);
            if (!lastSection.equals((Object)section)) {
                result.computeIfAbsent(lastSection, x -> new WireSegmentRenderData()).add(this.points[i].offset(lastSection));
                result.computeIfAbsent(section, x -> new WireSegmentRenderData()).add(vertices);
            } else {
                result.computeIfAbsent(section, x -> new WireSegmentRenderData()).add(vertices);
            }
            lastVertices = vertices;
            lastSection = section;
        }
        float length = 0.0f;
        for (WireSegmentRenderData segment : result.values()) {
            length += segment.finish(decorations, length);
        }
        return result;
    }
}

