/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.paw.mixin.client.RenderChunkAccess;
import de.mrjulsen.wires.graph.WireGraphClient;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.render.WireSegmentRenderDataBatch;
import de.mrjulsen.wires.util.ClientUtils;
import de.mrjulsen.wires.util.CompiledChunkExtension;
import de.mrjulsen.wires.util.Utils;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;

public class WireRenderer
implements ResourceManagerReloadListener {
    public static final Cache<TextureAtlasSprite> WIRE_TEXTURE = new Cache(() -> Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(Utils.resLoc("wiresapi", "block/wire")));

    public void m_6213_(@Nonnull ResourceManager pResourceManager) {
        WIRE_TEXTURE.clear();
    }

    public static void renderConnectionsInSection(Set<RenderType> layers, ChunkBufferBuilderPack buffers, BlockAndTintGetter region, ChunkRenderDispatcher.RenderChunk renderChunk) {
        BlockPos chunkOrigin = renderChunk.m_112839_();
        SectionPos chunkSection = SectionPos.m_123199_((BlockPos)chunkOrigin);
        for (WireGraphClient graph : WireGraphManager.getAllClient(ClientUtils.level())) {
            if (!graph.hasConnectionsInSection(chunkSection)) continue;
            RenderType renderType = RenderType.m_110463_();
            BufferBuilder builder = buffers.m_108839_(renderType);
            if (layers.add(renderType)) {
                ((RenderChunkAccess)renderChunk).invokeBeginLayer(builder);
            }
            WireRenderer.renderConnectionsInternal(graph, (VertexConsumer)builder, region, chunkSection, new PoseStack());
            CompiledChunkExtension ext = (CompiledChunkExtension)renderChunk.f_112784_.get();
            ext.setHasWires(true);
            Collection<WireSegmentRenderDataBatch> connections = graph.connectionsInSection(chunkSection);
            if (layers.add(renderType)) {
                ((RenderChunkAccess)renderChunk).invokeBeginLayer(builder);
            }
            for (WireSegmentRenderDataBatch connection : connections) {
                connection.render(region, (VertexConsumer)builder);
            }
        }
    }

    public static void renderConnectionsInSection(Function<RenderType, VertexConsumer> layers, ChunkBuildBuffers buffers, BlockAndTintGetter region, SectionPos section) {
        for (WireGraphClient graph : WireGraphManager.getAllClient(ClientUtils.level())) {
            if (!graph.hasConnectionsInSection(section)) continue;
            RenderType renderType = RenderType.m_110463_();
            VertexConsumer vertexConsumer = layers.apply(renderType);
            WireRenderer.renderConnectionsInternal(graph, vertexConsumer, region, section, new PoseStack());
        }
    }

    private static void renderConnectionsInternal(WireGraphClient graph, VertexConsumer vertexConsumer, BlockAndTintGetter region, SectionPos section, PoseStack poseStack) {
        Collection<WireSegmentRenderDataBatch> connections = graph.connectionsInSection(section);
        for (WireSegmentRenderDataBatch connection : connections) {
            connection.render(region, vertexConsumer);
        }
    }
}

