/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.mrjulsen.wires.decoration.WireDecorationData;
import de.mrjulsen.wires.decoration.WireDecorationRenderData;
import de.mrjulsen.wires.render.WireRenderPoint;
import de.mrjulsen.wires.render.WireRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WireSegmentRenderData {
    private final List<WireRenderPoint> points = new ArrayList<WireRenderPoint>();
    private final List<WireDecorationRenderData> decorations = new ArrayList<WireDecorationRenderData>();
    private float length;

    public float finish(TreeMap<Float, WireDecorationData> decorations, float lengthOffset) {
        this.decorations.clear();
        float oldLength = 0.0f;
        this.length = 0.0f;
        Vector3f a = new Vector3f((Vector3fc)this.points.get(0).vertex(WireRenderPoint.VertexCorner.CENTER));
        for (int i = 1; i < this.count(); ++i) {
            float decoPos;
            Vector3f b = new Vector3f((Vector3fc)this.points.get(i).vertex(WireRenderPoint.VertexCorner.CENTER));
            Vector3f normal = new Vector3f((Vector3fc)b).sub((Vector3fc)a).normalize();
            oldLength = this.length;
            this.length += a.distance((Vector3fc)b);
            Map.Entry<Float, WireDecorationData> entry = null;
            while (decorations != null && (entry = decorations.firstEntry()) != null && (decoPos = entry.getKey().floatValue() - lengthOffset) > oldLength && decoPos <= this.length) {
                WireDecorationData deco = decorations.pollFirstEntry().getValue();
                float localPos = decoPos - oldLength;
                this.decorations.add(new WireDecorationRenderData(new Vector3f((Vector3fc)a).add((Vector3fc)new Vector3f((Vector3fc)normal).mul(localPos)), normal, deco));
            }
            a = b;
        }
        return this.length;
    }

    public void add(WireRenderPoint point) {
        this.points.add(point);
    }

    public WireRenderPoint getPoint(int index) {
        return this.points.get(index);
    }

    public int count() {
        return this.points.size();
    }

    public void render(BlockAndTintGetter level, SectionPos origin, VertexConsumer vertexConsumer, int color) {
        if (this.points.size() < 2) {
            return;
        }
        float u0 = ((TextureAtlasSprite)WireRenderer.WIRE_TEXTURE.get()).m_118409_();
        float v0 = ((TextureAtlasSprite)WireRenderer.WIRE_TEXTURE.get()).m_118411_();
        float u1 = ((TextureAtlasSprite)WireRenderer.WIRE_TEXTURE.get()).m_118410_();
        float v1 = ((TextureAtlasSprite)WireRenderer.WIRE_TEXTURE.get()).m_118412_();
        BlockPos originPos = origin.m_123249_();
        WireRenderPoint lastVertices = this.points.get(0);
        for (int i = 1; i < this.points.size(); ++i) {
            WireRenderPoint vertices = this.points.get(i);
            Vector3f center = vertices.vertex(WireRenderPoint.VertexCorner.CENTER);
            int light = WireSegmentRenderData.getLight(originPos.m_7918_((int)center.x(), (int)center.y(), (int)center.z()), level);
            Vector3f vertex = lastVertices.vertex(WireRenderPoint.VertexCorner.BOTTOM_LEFT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u0, v0).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = lastVertices.vertex(WireRenderPoint.VertexCorner.TOP_RIGHT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u0, v1).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = vertices.vertex(WireRenderPoint.VertexCorner.TOP_RIGHT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u1, v1).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = vertices.vertex(WireRenderPoint.VertexCorner.BOTTOM_LEFT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u1, v0).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = lastVertices.vertex(WireRenderPoint.VertexCorner.TOP_RIGHT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u0, v0).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = lastVertices.vertex(WireRenderPoint.VertexCorner.BOTTOM_LEFT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u0, v1).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = vertices.vertex(WireRenderPoint.VertexCorner.BOTTOM_LEFT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u1, v1).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = vertices.vertex(WireRenderPoint.VertexCorner.TOP_RIGHT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u1, v0).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = lastVertices.vertex(WireRenderPoint.VertexCorner.TOP_LEFT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u0, v0).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = lastVertices.vertex(WireRenderPoint.VertexCorner.BOTTOM_RIGHT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u0, v1).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = vertices.vertex(WireRenderPoint.VertexCorner.BOTTOM_RIGHT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u1, v1).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = vertices.vertex(WireRenderPoint.VertexCorner.TOP_LEFT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u1, v0).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = lastVertices.vertex(WireRenderPoint.VertexCorner.BOTTOM_RIGHT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u0, v0).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = lastVertices.vertex(WireRenderPoint.VertexCorner.TOP_LEFT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u0, v1).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = vertices.vertex(WireRenderPoint.VertexCorner.TOP_LEFT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u1, v1).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            vertex = vertices.vertex(WireRenderPoint.VertexCorner.BOTTOM_RIGHT);
            vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_193479_(color).m_7421_(u1, v0).m_85969_(light).m_86008_(OverlayTexture.f_118083_).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            lastVertices = vertices;
        }
        PoseStack poseStack = new PoseStack();
        for (WireDecorationRenderData deco : this.decorations) {
            poseStack.m_85836_();
            poseStack.m_252880_(deco.worldPos().x(), deco.worldPos().y(), deco.worldPos().z());
            poseStack.m_85836_();
            poseStack.m_252781_(WireSegmentRenderData.getYawPitchQuaternion(deco.direction()));
            BlockPos decoPos = originPos.m_7918_((int)deco.worldPos().x(), (int)deco.worldPos().y(), (int)deco.worldPos().z());
            deco.data().getDecoration().getRenderer().render(poseStack, vertexConsumer, deco.worldPos(), deco.direction(), WireSegmentRenderData.getLight(decoPos, level));
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    private static int getLight(BlockPos pos, BlockAndTintGetter level) {
        try {
            return LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)pos);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static Quaternionf getYawPitchQuaternion(Vector3f direction) {
        Vector3f dir = new Vector3f((Vector3fc)direction).normalize();
        float yaw = (float)Math.atan2(-dir.x, -dir.z);
        float pitch = (float)Math.asin(dir.y);
        return new Quaternionf().rotateY(yaw).rotateX(pitch);
    }
}

