/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.wires.util;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;

public class SafeChunkUtils {
    private static final Map<LevelAccessor, Set<ChunkPos>> unloadingChunks = new WeakHashMap<LevelAccessor, Set<ChunkPos>>();

    public static LevelChunk getSafeChunk(LevelAccessor w, BlockPos pos) {
        ChunkSource provider = w.m_7726_();
        ChunkPos chunkPos = new ChunkPos(pos);
        if (unloadingChunks.getOrDefault(w, (Set<ChunkPos>)ImmutableSet.of()).contains(chunkPos)) {
            return null;
        }
        return provider.m_7131_(chunkPos.f_45578_, chunkPos.f_45579_);
    }

    public static boolean isChunkSafe(LevelAccessor w, BlockPos pos) {
        return SafeChunkUtils.getSafeChunk(w, pos) != null;
    }

    public static BlockEntity getSafeBE(LevelAccessor w, BlockPos pos) {
        LevelChunk c = SafeChunkUtils.getSafeChunk(w, pos);
        if (c == null) {
            return null;
        }
        return c.m_7702_(pos);
    }

    @Nonnull
    public static BlockState getBlockState(LevelAccessor w, BlockPos pos) {
        LevelChunk c = SafeChunkUtils.getSafeChunk(w, pos);
        if (c == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return c.m_8055_(pos);
    }

    public static int getRedstonePower(Level w, BlockPos pos, Direction d) {
        if (!SafeChunkUtils.isChunkSafe((LevelAccessor)w, pos)) {
            return 0;
        }
        return w.m_277185_(pos, d);
    }

    public static void onTick(ServerLevel level) {
        unloadingChunks.remove(level);
    }
}

