/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.mutantszombies.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.petemc.mutantszombies.entity.ZombieBruteEntity;
import org.jetbrains.annotations.NotNull;

public class ZombieBruteModel<T extends ZombieBruteEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mutantszombies", "zombie_brute_layer"), "main");
    public final ModelPart head;
    public final ModelPart torso;
    public final ModelPart right_arm;
    public final ModelPart left_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public ZombieBruteModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.torso = root.m_171324_("torso");
        this.left_arm = root.m_171324_("left_arm");
        this.right_arm = root.m_171324_("right_arm");
        this.left_leg = root.m_171324_("left_leg");
        this.right_leg = root.m_171324_("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(71, 49).m_171488_(-6.0f, -4.0f, -7.0f, 11.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(69, 99).m_171488_(-5.0f, 4.0f, -6.0f, 9.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-15.0f, (float)-17.0f));
        partdefinition.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-15.0f, -41.0f, -15.0f, 29.0f, 21.0f, 28.0f, new CubeDeformation(0.0f)).m_171514_(0, 49).m_171488_(-13.0f, -20.0f, -9.0f, 25.0f, 7.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-20.0f, (float)-11.0f, (float)-7.0f));
        right_arm.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(86, 0).m_171488_(-23.0f, 14.0f, 5.0f, 8.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)20.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        right_arm.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-4.0f, 0.0f, -3.0f, 10.0f, 18.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)19.0f, (float)-11.0f, (float)-7.0f));
        left_arm.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(80, 77).m_171488_(14.0f, 14.0f, 5.0f, 8.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-19.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        left_arm.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(40, 77).m_171488_(13.0f, 0.0f, -3.0f, 10.0f, 18.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-19.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(98, 99).m_171488_(-2.0f, 11.0f, -3.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)11.0f, (float)-1.0f));
        left_leg.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(104, 70).m_171488_(3.0f, -7.0f, 1.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)13.0f, (float)-3.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        left_leg.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.6533f, -3.2527f, 7.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)1.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-2.0f, 11.0f, -3.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)11.0f, (float)-2.0f));
        right_leg.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(0, 105).m_171488_(-9.0f, -18.0f, -4.0f, 7.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)13.0f, (float)-3.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        right_leg.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(0, 49).m_171488_(-8.0f, -7.0f, 1.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)13.0f, (float)-3.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.left_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.right_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }

    public void prepareMobModel(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        int i = ((ZombieBruteEntity)((Object)pEntity)).getAttackAnimationTick();
        if (i > 0) {
            this.right_arm.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)i - pPartialTick), (float)10.0f);
            this.left_arm.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)i - pPartialTick), (float)10.0f);
        } else {
            this.right_arm.f_104203_ = (-0.2f + 1.5f * Mth.m_14156_((float)pLimbSwing, (float)13.0f)) * pLimbSwingAmount;
            this.left_arm.f_104203_ = (-0.2f - 1.5f * Mth.m_14156_((float)pLimbSwing, (float)13.0f)) * pLimbSwingAmount;
        }
    }
}

