/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.mutantszombies.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class CrawlerModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"mutantszombies", (String)"crawler_layer"), "main");
    public final ModelPart head;
    public final ModelPart torso;
    public final ModelPart left_arm;
    public final ModelPart right_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public CrawlerModel(ModelPart root) {
        this.head = root.getChild("head");
        this.torso = root.getChild("torso");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)15.0f, (float)-4.0f));
        head.addOrReplaceChild("bottomjaw_r1", CubeListBuilder.create().texOffs(37, 28).addBox(-3.0f, 0.0f, -5.0f, 6.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-1.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("topjaw_r1", CubeListBuilder.create().texOffs(31, 0).addBox(-3.0f, -4.0f, -6.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-1.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition teeth = head.addOrReplaceChild("teeth", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)-1.0f));
        PartDefinition bottomteeth = teeth.addOrReplaceChild("bottomteeth", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        bottomteeth.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(3, 12).addBox(-1.0f, -1.0f, -5.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(11, 12).addBox(-3.0f, -1.0f, -5.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(4, 4).addBox(1.0f, -1.0f, -5.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition topteeth = teeth.addOrReplaceChild("topteeth", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        topteeth.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(8, 11).addBox(1.0f, 0.0f, -6.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(7, 0).addBox(-2.0f, 0.0f, -6.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition rightcheek = head.addOrReplaceChild("rightcheek", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)3.0f, (float)-4.0f));
        rightcheek.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(11, 0).addBox(0.0f, -4.0053f, -0.5374f, 0.5f, 4.0f, 0.5f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3924f, (float)0.0167f, (float)0.0403f));
        rightcheek.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(9, 5).addBox(-3.0f, -4.0f, -4.0f, 0.5f, 6.0f, 0.5f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-2.0f, (float)3.0f, (float)0.1308f, (float)-0.0057f, (float)0.0433f));
        PartDefinition leftcheek = head.addOrReplaceChild("leftcheek", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)3.0f, (float)-4.0f));
        leftcheek.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 7).addBox(-0.5f, -5.0053f, -0.5374f, 0.5f, 5.0f, 0.5f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3957f, (float)0.1209f, (float)-0.0503f));
        leftcheek.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(5, 6).addBox(2.5f, -4.5f, -4.0f, 0.5f, 6.0f, 0.5f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-2.0f, (float)3.0f, (float)0.218f, (float)0.0094f, (float)-0.0426f));
        PartDefinition tounge = head.addOrReplaceChild("tounge", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)-8.0f));
        tounge.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(0, 4).addBox(-0.4f, 0.0307f, -2.0984f, 1.0f, 0.5f, 2.2f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6988f, (float)0.0859f, (float)0.0152f));
        tounge.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.6166f, -2.3061f, 1.5f, 0.5f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)2.0f, (float)0.3917f, (float)-0.3564f, (float)-0.151f));
        tounge.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(46, 10).addBox(-1.0f, -0.5f, -5.0f, 2.0f, 0.5f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)7.0f, (float)0.1772f, (float)0.1719f, (float)0.0306f));
        PartDefinition torso = partdefinition.addOrReplaceChild("torso", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)2.0f));
        torso.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -7.0f, 8.0f, 3.0f, 15.0f, new CubeDeformation(0.0f)).texOffs(30, 18).addBox(-4.0f, -5.0f, -7.0f, 8.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)16.0f, (float)-3.0f));
        left_arm.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(37, 36).addBox(3.0f, -1.0f, -5.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.0f, (float)0.897f, (float)0.3093f, (float)0.4295f));
        left_arm.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(0, 41).addBox(0.0f, -2.0f, -3.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.0f, (float)0.9964f, (float)-0.3332f, (float)-0.468f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)16.0f, (float)-3.0f));
        right_arm.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(11, 43).addBox(-5.0f, -1.0f, -5.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.0f, (float)0.897f, (float)-0.3093f, (float)-0.4295f));
        right_arm.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(29, 45).addBox(-3.0f, -2.0f, -3.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.0f, (float)0.9964f, (float)0.3332f, (float)0.468f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)17.0f, (float)10.0f));
        left_leg.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(15, 20).addBox(4.25f, 3.0f, -3.0f, 2.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)2.0f, (float)-1.0f, (float)-0.3491f, (float)0.0f, (float)-0.3491f));
        left_leg.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(22, 33).addBox(-0.5f, -1.7934f, -2.3912f, 3.5f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-1.0f, (float)-2.4871f, (float)0.0f, (float)-0.3491f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)17.0f, (float)9.0f));
        right_leg.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(0, 18).addBox(-6.25f, 3.0f, -3.0f, 2.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)2.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.3491f));
        right_leg.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(0, 31).addBox(-3.0f, -1.7934f, -2.3912f, 3.5f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)-2.4871f, (float)0.0f, (float)0.3491f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

