/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.mutantszombies.entity;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.petemc.mutantszombies.entity.BlisterZombieEntity;
import net.petemc.mutantszombies.entity.CrawlerEntity;
import net.petemc.mutantszombies.entity.SpitterEntity;
import net.petemc.mutantszombies.entity.SpitterEntityProjectile;
import net.petemc.mutantszombies.entity.ZombieBruteEntity;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"mutantszombies");
    public static final Supplier<EntityType<BlisterZombieEntity>> BLISTER_ZOMBIE = ENTITY_TYPES.register("blister_zombie", () -> EntityType.Builder.of(BlisterZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(50).setUpdateInterval(3).sized(0.9f, 2.7f).build("blister_zombie"));
    public static final Supplier<EntityType<CrawlerEntity>> CRAWLER = ENTITY_TYPES.register("crawler", () -> EntityType.Builder.of(CrawlerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(15).setUpdateInterval(3).sized(0.6f, 0.8f).build("crawler"));
    public static final Supplier<EntityType<SpitterEntity>> SPITTER = ENTITY_TYPES.register("spitter", () -> EntityType.Builder.of(SpitterEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(55).setUpdateInterval(3).sized(2.2f, 3.0f).build("spitter"));
    public static final Supplier<EntityType<SpitterEntityProjectile>> SPITTER_PROJECTILE = ENTITY_TYPES.register("spitter_projectile", () -> EntityType.Builder.of(SpitterEntityProjectile::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f).build("spitter_projectile"));
    public static final Supplier<EntityType<ZombieBruteEntity>> ZOMBIE_BRUTE = ENTITY_TYPES.register("zombie_brute", () -> EntityType.Builder.of(ZombieBruteEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(35).setUpdateInterval(3).sized(2.7f, 3.0f).build("zombie_brute"));

    public static void initModEntities() {
    }

    public static void register(IEventBus eventBus) {
        ENTITY_TYPES.register(eventBus);
    }
}

