/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.mutantszombies.entity;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.petemc.mutantszombies.entity.ModEntities;
import org.jetbrains.annotations.NotNull;

public class SpitterEntityProjectile
extends AbstractArrow
implements ItemSupplier {
    public SpitterEntityProjectile(EntityType<? extends SpitterEntityProjectile> type, Level level) {
        super(type, level);
    }

    public SpitterEntityProjectile(LivingEntity entity, Level level) {
        super(ModEntities.SPITTER_PROJECTILE.get(), entity, level, new ItemStack((ItemLike)Items.SLIME_BALL), null);
    }

    public SpitterEntityProjectile(EntityType<? extends SpitterEntityProjectile> type, double x, double y, double z, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.SPITTER_PROJECTILE.get(), x, y, z, level, pickupItemStack, null);
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.SLIME_BLOCK_PLACE;
    }

    protected void onHitBlock(@NotNull BlockHitResult pResult) {
        super.onHitBlock(pResult);
        this.setSoundEvent(SoundEvents.SLIME_BLOCK_PLACE);
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.SLIME_BALL);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ItemStack getItem() {
        return new ItemStack((ItemLike)Items.SLIME_BALL);
    }
}

