/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.mutantszombies.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.petemc.mutantszombies.MutantsZombies;

public class BreakTreesGoal
extends Goal {
    private final Monster mob;
    private final float breakProgressPerTick = 0.04f;
    private BlockPos targetBlock;
    private float scaledTargetDestroyTime;
    private float breakProgress;
    private float ratio;

    public BreakTreesGoal(Monster mob) {
        this.mob = mob;
    }

    public static float blockPosDistance(Entity entity, BlockPos pos) {
        return BreakTreesGoal.blockPosDistance(entity.m_20183_(), pos);
    }

    public static float blockPosDistance(BlockPos pos1, BlockPos pos2) {
        float x = pos1.m_123341_() - pos2.m_123341_();
        float y = pos1.m_123342_() - pos2.m_123342_();
        float z = pos1.m_123343_() - pos2.m_123343_();
        return Mth.m_14116_((float)(x * x + y * y + z * z));
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8045_() {
        return BreakTreesGoal.blockPosDistance((Entity)this.mob, this.targetBlock) <= 3.0f && this.breakProgress <= this.scaledTargetDestroyTime;
    }

    public void m_8056_() {
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8037_() {
        this.breakProgress += 0.04f;
        this.mob.m_6674_(InteractionHand.MAIN_HAND);
        if (this.breakProgress >= this.scaledTargetDestroyTime) {
            this.mob.m_9236_().m_46961_(this.targetBlock, true);
            return;
        }
        this.mob.m_9236_().m_6801_(this.mob.m_19879_(), this.targetBlock, (int)(this.breakProgress * this.ratio));
    }

    public void m_8041_() {
        this.mob.m_9236_().m_6801_(this.mob.m_19879_(), this.targetBlock, 0);
        this.breakProgress = 0.0f;
        this.targetBlock = null;
        this.scaledTargetDestroyTime = 0.0f;
        this.mob.m_21573_().m_26569_();
    }

    public boolean m_8036_() {
        float destroyTime;
        if (!this.mob.f_19862_) {
            return false;
        }
        LivingEntity targetEntity = this.mob.m_5448_();
        if (targetEntity == null) {
            return false;
        }
        if (this.mob.m_217043_().m_188501_() < 1.0f) {
            return false;
        }
        Level world = this.mob.m_9236_();
        Direction direction = this.mob.m_6350_();
        BlockPos blockPos = this.mob.m_20183_();
        blockPos = blockPos.m_121955_(direction.m_122436_()).m_7918_(0, 1, 0);
        if (!this.mob.m_21573_().m_26571_()) {
            return false;
        }
        int yDistance = Math.abs(targetEntity.m_146904_() - this.mob.m_146904_());
        int yCheckModifier = yDistance > 2 ? ((double)targetEntity.m_146904_() > this.mob.m_20186_() ? 1 : -2) : -1;
        BlockState state = world.m_8055_(blockPos);
        Block block = state.m_60734_();
        if ((block instanceof AirBlock || block.m_48673_(state)) && ((block = (state = world.m_8055_(blockPos = blockPos.m_7918_(0, yCheckModifier, 0))).m_60734_()) instanceof AirBlock || block.m_48673_(state))) {
            return false;
        }
        this.targetBlock = blockPos;
        this.scaledTargetDestroyTime = destroyTime = world.m_8055_(this.targetBlock).m_60734_().m_155943_();
        MutantsZombies.LOGGER.info("----------------------------> Block: {} destroyTime: {}", (Object)world.m_8055_(this.targetBlock).m_60734_(), (Object)Float.valueOf(world.m_8055_(this.targetBlock).m_60734_().m_155943_()));
        if (this.scaledTargetDestroyTime < 0.0f) {
            return false;
        }
        if (destroyTime > 2.0f) {
            return false;
        }
        this.ratio = 10.0f / this.scaledTargetDestroyTime;
        return true;
    }
}

