/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.mutantszombies.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.petemc.mutantszombies.client.state.RottenMutantEntityRenderState;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class RottenMutantModel
extends EntityModel<RottenMutantEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"mutantszombies", (String)"rotten_mutant_layer"), "main");
    private final ModelPart head;
    private final ModelPart torso;
    private final ModelPart metalrods;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public RottenMutantModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.torso = root.getChild("torso");
        this.metalrods = this.torso.getChild("metalrods");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-8.5f, (float)-4.5f, (float)-0.1274f, (float)0.0f, (float)0.0436f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(15, 106).addBox(-1.0f, -3.0f, -3.0f, 2.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.85f, (float)-1.675f, (float)-3.075f, (float)0.0f, (float)-0.4363f, (float)1.5708f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(18, 31).addBox(-1.0f, -3.0f, -3.0f, 2.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.75f, (float)-6.5f, (float)-0.15f, (float)-0.436f, (float)0.0184f, (float)-3.102f));
        PartDefinition cube_r3 = head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(21, 105).addBox(-1.0f, -3.0f, -3.0f, 2.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-8.5f, (float)-4.5f, (float)0.0f, (float)-0.4363f, (float)1.5708f));
        PartDefinition cube_r4 = head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(7, 101).addBox(-1.0f, -3.0f, -3.0f, 2.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-4.25f, (float)-2.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = head.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(35, 27).addBox(4.0f, -1.0f, -5.0f, 0.5f, 1.0f, 23.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-3.25f, (float)-8.975f, (float)0.3745f, (float)-1.0204f, (float)0.1668f));
        PartDefinition cube_r6 = head.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(1, 97).addBox(-4.5468f, -10.2426f, -10.5803f, 9.0f, 9.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)3.4451f, (float)-4.1885f, (float)-1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition torso = partdefinition.addOrReplaceChild("torso", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)1.0f));
        PartDefinition cube_r7 = torso.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -13.9403f, -5.0f, 12.0f, 14.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = torso.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(0, 83).addBox(0.5f, -0.1856f, 1.1898f, 7.0f, 6.0f, 7.0f, new CubeDeformation(-0.75f)), PartPose.offsetAndRotation((float)-4.0f, (float)-15.2903f, (float)-10.903f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition metalrods = torso.addOrReplaceChild("metalrods", CubeListBuilder.create().texOffs(35, 27).addBox(4.0f, 1.25f, -5.0f, 0.5f, 1.0f, 23.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-10.0f, (float)-14.0f));
        PartDefinition cube_r9 = metalrods.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(32, 24).addBox(-4.5f, -1.0f, -7.0f, 0.5f, 1.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0173f, (float)0.192f, (float)-0.1791f));
        PartDefinition cube_r10 = metalrods.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(73, 0).addBox(-5.5f, -1.0f, -4.0f, 0.5f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.176f, (float)0.1289f, (float)-0.0229f));
        PartDefinition cube_r11 = metalrods.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(61, 43).addBox(-4.5f, -3.7f, -7.0f, 0.5f, 0.7f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.25f, (float)7.0f, (float)3.25f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)-7.0f, (float)-3.0f));
        PartDefinition cube_r12 = left_arm.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(32, 67).addBox(0.0f, 6.0f, -2.75f, 4.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)11.75f, (float)-5.75f, (float)1.5371f, (float)0.1248f, (float)0.2446f));
        PartDefinition cube_r13 = left_arm.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(31, 11).addBox(0.0f, 1.0f, -9.0f, 4.0f, 4.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)3.0f, (float)-2.0f, (float)1.7975f, (float)0.4542f, (float)-0.4509f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-6.0f, (float)-7.0f, (float)-3.0f));
        PartDefinition cube_r14 = right_arm.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(70, 20).addBox(-4.7f, -1.0f, -2.723f, 4.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.825f, (float)11.0f, (float)-6.0f, (float)1.0898f, (float)-0.3133f, (float)-0.0098f));
        PartDefinition cube_r15 = right_arm.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(0, 38).addBox(-4.0f, -1.0f, -9.0f, 4.0f, 4.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-1.0f, (float)1.0036f, (float)0.0f, (float)0.5236f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(17, 38).addBox(-2.075f, 14.0f, -4.0f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.25f)), PartPose.offset((float)3.0f, (float)4.0f, (float)0.0f));
        PartDefinition cube_r16 = left_leg.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(74, 55).addBox(-6.1f, -8.6f, -2.1f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)4.0f, (float)7.0f, (float)-1.0f, (float)-0.1749f, (float)-0.0058f, (float)0.0013f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)3.0f, (float)0.0f));
        PartDefinition cube_r17 = right_leg.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(0, 28).addBox(-6.5f, -7.0f, -2.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)3.5f, (float)20.675f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition cube_r18 = right_leg.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(29, 78).addBox(-5.0f, -10.5554f, -2.3915f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)2.225f, (float)9.0f, (float)-0.5f, (float)-0.1279f, (float)0.0093f, (float)0.0902f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull RottenMutantEntityRenderState renderState) {
        super.setupAnim((EntityRenderState)renderState);
        this.head.yRot = renderState.yRot / 57.295776f;
        this.head.xRot = renderState.xRot / 57.295776f;
        this.right_arm.xRot = Mth.cos((float)(renderState.walkAnimationPos * 0.6662f + (float)Math.PI)) * renderState.walkAnimationSpeed;
        this.left_leg.xRot = Mth.cos((float)(renderState.walkAnimationPos * 1.0f)) * -1.0f * renderState.walkAnimationSpeed;
        this.left_arm.xRot = Mth.cos((float)(renderState.walkAnimationPos * 0.5f)) * renderState.walkAnimationSpeed;
        this.right_leg.xRot = Mth.cos((float)(renderState.walkAnimationPos * 1.0f)) * 1.0f * renderState.walkAnimationSpeed;
    }
}

