/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.saveandloadinventories_common_forge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.collective_common_forge.functions.PlayerFunctions;
import com.natamus.collective_common_forge.functions.StringFunctions;
import com.natamus.saveandloadinventories_common_forge.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandSaveinventory {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"saveinventory").requires(iCommandSender -> iCommandSender.hasPermission(2))).then(Commands.argument((String)"inventory-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandSaveinventory.saveinventory((CommandContext<CommandSourceStack>)command))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"si").requires(iCommandSender -> iCommandSender.hasPermission(2))).then(Commands.argument((String)"inventory-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandSaveinventory.saveinventory((CommandContext<CommandSourceStack>)command))));
    }

    private static int saveinventory(CommandContext<CommandSourceStack> command) {
        ServerPlayer player;
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        try {
            player = source.getPlayerOrException();
        }
        catch (CommandSyntaxException ex) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"This command can only be executed as a player in-game.", (ChatFormatting)ChatFormatting.RED);
            return 1;
        }
        String inventoryname = StringArgumentType.getString(command, (String)"inventory-name").toLowerCase();
        if (inventoryname.trim() == "") {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("The inventory name '" + inventoryname + "' is invalid."), (ChatFormatting)ChatFormatting.RED);
            return 0;
        }
        String gearstring = PlayerFunctions.getPlayerGearString((Player)player);
        if (StringFunctions.sequenceCount((String)gearstring, (String)"\n") < 40) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Something went wrong while generating the save file content for your inventory.", (ChatFormatting)ChatFormatting.RED);
            return 0;
        }
        if (!Util.writeGearStringToFile(inventoryname, gearstring)) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Something went wrong while saving the content of your inventory as '" + inventoryname + "'."), (ChatFormatting)ChatFormatting.RED);
            return 0;
        }
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Successfully saved your inventory as '" + inventoryname + "'."), (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)("You can load it with the command '/loadinventory " + inventoryname + "'."), (ChatFormatting)ChatFormatting.DARK_GREEN);
        return 1;
    }
}

