/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.saveandloadinventories_common_neoforge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.functions.PlayerFunctions;
import com.natamus.saveandloadinventories_common_neoforge.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandLoadinventory {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"loadinventory").requires(iCommandSender -> iCommandSender.hasPermission(2))).then(Commands.argument((String)"inventory-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandLoadinventory.loadInventory((CommandContext<CommandSourceStack>)command)))).then(Commands.argument((String)"inventory-name", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"player-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandLoadinventory.loadInventoryForPlayerName((CommandContext<CommandSourceStack>)command)))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"li").requires(iCommandSender -> iCommandSender.hasPermission(2))).then(Commands.argument((String)"inventory-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandLoadinventory.loadInventory((CommandContext<CommandSourceStack>)command)))).then(Commands.argument((String)"inventory-name", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"player-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandLoadinventory.loadInventoryForPlayerName((CommandContext<CommandSourceStack>)command)))));
    }

    private static int loadInventory(CommandContext<CommandSourceStack> command) {
        ServerPlayer player;
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        try {
            player = source.getPlayerOrException();
        }
        catch (CommandSyntaxException ex) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"This command can only be executed as a player in-game.", (ChatFormatting)ChatFormatting.RED);
            return 1;
        }
        String inventoryname = StringArgumentType.getString(command, (String)"inventory-name").toLowerCase();
        if (inventoryname.trim() == "") {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("The inventory name '" + inventoryname + "' is invalid."), (ChatFormatting)ChatFormatting.RED);
            return 0;
        }
        String gearstring = Util.getGearStringFromFile(inventoryname);
        if (gearstring == "") {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Unable to load the content of the inventory with the name '" + inventoryname + "'."), (ChatFormatting)ChatFormatting.RED);
            return 0;
        }
        PlayerFunctions.setPlayerGearFromString((Player)player, (String)gearstring);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Successfully loaded '" + inventoryname + "' to your inventory."), (ChatFormatting)ChatFormatting.DARK_GREEN);
        return 1;
    }

    private static int loadInventoryForPlayerName(CommandContext<CommandSourceStack> command) {
        ServerPlayer player;
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        try {
            player = source.getPlayerOrException();
        }
        catch (CommandSyntaxException ex) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"This command can only be executed as a player in-game.", (ChatFormatting)ChatFormatting.RED);
            return 1;
        }
        String inventoryname = StringArgumentType.getString(command, (String)"inventory-name").toLowerCase();
        if (inventoryname.trim() == "") {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("The inventory name '" + inventoryname + "' is invalid."), (ChatFormatting)ChatFormatting.RED);
            return 0;
        }
        String targetname = StringArgumentType.getString(command, (String)"player-name").toLowerCase();
        Player target = PlayerFunctions.matchPlayer((Player)player, (String)targetname.toLowerCase());
        if (target == null) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Unable to find an online player with the name '" + targetname + "'."), (ChatFormatting)ChatFormatting.RED);
            return 0;
        }
        String gearstring = Util.getGearStringFromFile(inventoryname);
        if (gearstring == "") {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Unable to load the content of the inventory with the name '" + inventoryname + "'."), (ChatFormatting)ChatFormatting.RED);
            return 0;
        }
        PlayerFunctions.setPlayerGearFromString((Player)target, (String)gearstring);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Successfully loaded '" + inventoryname + "' to the inventory of '" + target.getName().getString() + "'."), (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((Player)target, (String)("Your inventory has been replaced with the preset named '" + inventoryname + "'."), (ChatFormatting)ChatFormatting.DARK_GREEN);
        return 1;
    }
}

