/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.ifwootaddon.datagen;

import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import wootrevived.ifwootaddon.upgrades.LaserDrill;
import wootrevived.ifwootaddon.upgrades.MobCrusher;
import wootrevived.ifwootaddon.upgrades.MobSlaughterFactory;

public class Items
extends ItemModelProvider {
    public Items(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "ifwootaddon", existingFileHelper);
    }

    protected void registerModels() {
        this.itemGenerated(MobCrusher.MOB_CRUSHER_ITEM);
        this.itemGenerated(MobSlaughterFactory.MOB_SLAUGHTER_FACTORY_ITEM);
        this.itemGenerated(LaserDrill.LASER_DRILL_ITEM);
    }

    public ResourceLocation getItemResource(Item item) {
        return Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item)).withPrefix("item/");
    }

    public ResourceLocation getBlockResource(Block block) {
        return Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)).withPrefix("block/");
    }

    public void itemBucket(DeferredHolder<Item, ? extends Item> item, DeferredHolder<Fluid, ? extends Fluid> fluid) {
        ResourceLocation itemResource = this.getItemResource((Item)item.get());
        ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(itemResource.getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.tryBuild((String)"neoforge", (String)"item/bucket")))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid((Fluid)fluid.get());
    }

    public void parentedBlock(DeferredHolder<Item, ? extends Item> item, DeferredHolder<Block, ? extends Block> block) {
        ResourceLocation itemResource = this.getItemResource((Item)item.get());
        ResourceLocation blockResource = this.getBlockResource((Block)block.get());
        ((ItemModelBuilder)this.getBuilder(itemResource.getPath())).parent((ModelFile)this.getExistingFile(blockResource));
    }

    public void itemGenerated(DeferredHolder<Item, ? extends Item> item) {
        ResourceLocation itemResource = this.getItemResource((Item)item.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(itemResource.getPath())).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", itemResource);
    }

    public void itemGenerated(DeferredHolder<Item, ? extends Item> item, ResourceLocation texture) {
        ResourceLocation itemResource = this.getItemResource((Item)item.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(itemResource.getPath())).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", texture);
    }

    public void itemHandheld(DeferredHolder<Item, ? extends Item> item) {
        ResourceLocation itemResource = this.getItemResource((Item)item.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(itemResource.getPath())).parent((ModelFile)this.getExistingFile(this.mcLoc("item/handheld")))).texture("layer0", itemResource);
    }
}

