/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.ifwootaddon.datagen.recipes;

import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.recipe.LaserDrillFluidRecipe;
import com.buuz135.industrial.recipe.LaserDrillOreRecipe;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import com.buuz135.industrial.utils.IndustrialTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ItemExistsCondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.fluids.FluidStack;
import wootrevived.ifwootaddon.upgrades.LaserDrill;
import wootrevived.ifwootaddon.upgrades.MobCrusher;
import wootrevived.ifwootaddon.upgrades.MobSlaughterFactory;
import wootrevived.woot.registries.FluidsRegistry;
import wootrevived.woot.registries.ItemsRegistry;
import wootrevived.woot.registries.UpgradeItemsRegistry;

public class IFWootSerializableProvider
extends RecipeProvider {
    public IFWootSerializableProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, provider);
    }

    protected void buildRecipes(RecipeOutput output) {
        IFWootSerializableProvider.createDissolutionChamberRecipe(output, "laser_drill_upgrade", new DissolutionChamberRecipe(List.of(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UpgradeItemsRegistry.UPGRADE_BASE_ITEM.get()}), Ingredient.of((TagKey)IndustrialTags.Items.MACHINE_FRAME_ADVANCED), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UpgradeItemsRegistry.UPGRADE_BASE_ITEM.get()}), Ingredient.of((ItemLike[])new ItemLike[]{ModuleResourceProduction.FLUID_LASER_BASE.getBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{ModuleResourceProduction.FLUID_LASER_BASE.getBlock()}), Ingredient.of((TagKey)IndustrialTags.Items.GEAR_DIAMOND), Ingredient.of((ItemLike[])new ItemLike[]{ModuleResourceProduction.LASER_DRILL.getBlock()}), Ingredient.of((TagKey)IndustrialTags.Items.GEAR_DIAMOND)), new FluidStack((Fluid)FluidsRegistry.SOURCE_VITALITY_FUEL_FLUID.get(), 2000), 150, Optional.of(((LaserDrill)((Object)LaserDrill.LASER_DRILL_ITEM.get())).getDefaultInstance()), Optional.empty()));
        IFWootSerializableProvider.createDissolutionChamberRecipe(output, "mob_crusher_upgrade", new DissolutionChamberRecipe(List.of(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UpgradeItemsRegistry.UPGRADE_BASE_ITEM.get()}), Ingredient.of((TagKey)IndustrialTags.Items.MACHINE_FRAME_ADVANCED), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UpgradeItemsRegistry.UPGRADE_BASE_ITEM.get()}), Ingredient.of((ItemLike[])new ItemLike[]{ModuleAgricultureHusbandry.MOB_CRUSHER.getBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{ModuleAgricultureHusbandry.MOB_CRUSHER.getBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP}), Ingredient.of((TagKey)IndustrialTags.Items.GEAR_DIAMOND), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP})), new FluidStack((Fluid)FluidsRegistry.SOURCE_VITALITY_FUEL_FLUID.get(), 2000), 150, Optional.of(((MobCrusher)((Object)MobCrusher.MOB_CRUSHER_ITEM.get())).getDefaultInstance()), Optional.empty()));
        IFWootSerializableProvider.createDissolutionChamberRecipe(output, "mob_slaughter_factory_upgrade", new DissolutionChamberRecipe(List.of(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UpgradeItemsRegistry.UPGRADE_BASE_ITEM.get()}), Ingredient.of((TagKey)IndustrialTags.Items.MACHINE_FRAME_SIMPLE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UpgradeItemsRegistry.UPGRADE_BASE_ITEM.get()}), Ingredient.of((ItemLike[])new ItemLike[]{ModuleAgricultureHusbandry.SLAUGHTER_FACTORY.getBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{ModuleAgricultureHusbandry.SLAUGHTER_FACTORY.getBlock()}), Ingredient.of((TagKey)IndustrialTags.Items.GEAR_GOLD), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), Ingredient.of((TagKey)IndustrialTags.Items.GEAR_GOLD)), new FluidStack((Fluid)FluidsRegistry.SOURCE_VITALITY_FUEL_FLUID.get(), 2000), 150, Optional.of(((MobSlaughterFactory)((Object)MobSlaughterFactory.MOB_SLAUGHTER_FACTORY_ITEM.get())).getDefaultInstance()), Optional.empty()));
        IFWootSerializableProvider.createLaserDrillOreItemRecipe(output, (ItemLike)ItemsRegistry.STYGIAN_DUST_ITEM.get(), 2, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(List.of(), List.of()), new LaserDrillRarity.DimensionRarity(List.of(BuiltinDimensionTypes.NETHER), List.of()), 7, 117, 10));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "warden_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 30000), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"warden"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "wither_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 20000), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"wither"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "ender_dragon_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 10000), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"ender_dragon"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "wither_skeleton_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 5000), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"wither_skeleton"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "ghast_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 5000), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"ghast"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "enderman_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 5000), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"enderman"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "blaze_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 2000), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"blaze"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "zombie_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 1000), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"zombie"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "skeleton_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 1000), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"skeleton"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "creeper_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 1000), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"creeper"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "spider_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 1000), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"spider"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "cow_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 500), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cow"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "sheep_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 500), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"sheep"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "chicken_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 500), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chicken"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
        IFWootSerializableProvider.createLaserDrillFluidRecipe(output, "pig_mob_tears", "minecraft", new LaserDrillFluidRecipe(new FluidStack((Fluid)FluidsRegistry.SOURCE_MOB_TEARS_FLUID.get(), 500), 10, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"pig"), new LaserDrillRarity[]{new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList(), new ArrayList()), new LaserDrillRarity.DimensionRarity(new ArrayList(), new ArrayList()), -64, 256, 8)}));
    }

    public static void createDissolutionChamberRecipe(RecipeOutput recipeOutput, String name, DissolutionChamberRecipe recipe) {
        ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"ifwootaddon", (String)("dissolution_chamber/" + name));
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        ArrayList<ItemExistsCondition> conditions = new ArrayList<ItemExistsCondition>();
        if (recipe.output.isPresent()) {
            conditions.add(new ItemExistsCondition(BuiltInRegistries.ITEM.getKey((Object)((ItemStack)recipe.output.get()).getItem())));
        }
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder, conditions.toArray(new ICondition[conditions.size()]));
    }

    public static void createLaserDrillOreItemRecipe(RecipeOutput recipeOutput, ItemLike itemLike, int color, LaserDrillRarity ... rarity) {
        Ingredient output = Ingredient.of((ItemLike[])new ItemLike[]{itemLike});
        LaserDrillOreRecipe recipe = new LaserDrillOreRecipe(output, color, rarity);
        ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"ifwootaddon", (String)("laser_drill_ore/" + BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem()).getPath()));
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder);
    }

    public static void createLaserDrillFluidRecipe(RecipeOutput recipeOutput, String name, String modIdCondition, LaserDrillFluidRecipe recipe) {
        ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"ifwootaddon", (String)("laser_drill_fluid/" + name));
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder, new ICondition[]{new ModLoadedCondition(modIdCondition)});
    }
}

