/*
 * Decompiled with CFR 0.152.
 */
package comToi.simple_harvesting;

import comToi.simple_harvesting.SHConfig;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2242;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2421;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;

public class Simple_harvesting
implements ModInitializer {
    public static SHConfig CONFIG;
    public static boolean DisableFieldBreakOnJump;
    private static final class_2248[] HARVESTABLE_BLOCKS;
    private static final class_2248[] SPECIAL_HARVEST_BLOCKS;

    public void onInitialize() {
        File configFile = new File("config/simple_harvesting.json");
        CONFIG = new SHConfig(configFile);
        this.registerAttackBlockEvent();
        this.registerUseBlockEvent();
    }

    private void registerAttackBlockEvent() {
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (player.method_7337()) {
                return class_1269.field_5811;
            }
            class_2248 block = world.method_8320(pos).method_26204();
            if (this.isExcludedBlock(block)) {
                return class_1269.field_5811;
            }
            if (Simple_harvesting.CONFIG.DisableNormalHarvesting && (this.isCropBlock(world, pos) || this.isSpecialHarvestBlock(block) || this.isInBlockList(block))) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
    }

    private void registerUseBlockEvent() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (world.method_8608()) {
                return class_1269.field_5811;
            }
            if (hand != class_1268.field_5808) {
                return class_1269.field_5811;
            }
            class_1799 mainHand = player.method_6047();
            class_2338 pos = hitResult.method_17777();
            class_2680 state = world.method_8320(pos);
            class_2248 block = state.method_26204();
            class_3218 serverWorld = (class_3218)world;
            boolean isShift = player.method_5715();
            if (this.isExcludedBlock(block)) {
                return class_1269.field_5811;
            }
            if (mainHand.method_7909() instanceof class_1794 && !Simple_harvesting.CONFIG.HoeHarvestEnabled) {
                return class_1269.field_5811;
            }
            if (mainHand.method_7960() && !Simple_harvesting.CONFIG.HandHarvestEnabled) {
                return class_1269.field_5811;
            }
            if (Simple_harvesting.CONFIG.DisableNormalHarvesting) {
                return this.handleDisabledNormalHarvesting(player, world, serverWorld, mainHand, pos, block, state, isShift);
            }
            return this.handleEnabledNormalHarvesting(player, world, serverWorld, mainHand, pos, block, state);
        });
    }

    private class_1269 handleDisabledNormalHarvesting(class_1657 player, class_1937 world, class_3218 serverWorld, class_1799 mainHand, class_2338 pos, class_2248 block, class_2680 state, boolean isShift) {
        if (isShift) {
            if (mainHand.method_7909() instanceof class_1794 && Simple_harvesting.CONFIG.HoeHarvestEnabled) {
                if (this.isCropBlock(world, pos) || this.isSpecialHarvestBlock(block)) {
                    this.destroyCropsInRadius(world, player, pos);
                    return class_1269.field_5812;
                }
                if (this.isInBlockList(block)) {
                    this.destroyGrassInRadius(world, player, pos, mainHand);
                    return class_1269.field_5812;
                }
            } else if (mainHand.method_7960() && Simple_harvesting.CONFIG.HandHarvestEnabled && (this.isCropBlock(world, pos) || this.isSpecialHarvestBlock(block) || this.isInBlockList(block))) {
                world.method_8651(pos, true, (class_1297)player);
                return class_1269.field_5812;
            }
        } else if (mainHand.method_7909() instanceof class_1794 && Simple_harvesting.CONFIG.HoeHarvestEnabled) {
            if (this.isCropBlock(world, pos) || this.isSpecialHarvestBlock(block)) {
                this.harvestAdjacentCrops(world, serverWorld, player, pos, block, state, true);
                if (Simple_harvesting.CONFIG.HoeUsesEnabled && !player.method_7337()) {
                    this.damageTool(mainHand, player);
                }
                return class_1269.field_5812;
            }
            if (this.isInBlockList(block)) {
                this.destroyGrassInRadius(world, player, pos, mainHand);
                return class_1269.field_5812;
            }
        } else if (mainHand.method_7960() && Simple_harvesting.CONFIG.HandHarvestEnabled && (this.isCropBlock(world, pos) || this.isSpecialHarvestBlock(block))) {
            this.harvestSingleCrop(world, serverWorld, player, pos, block, state, true);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private class_1269 handleEnabledNormalHarvesting(class_1657 player, class_1937 world, class_3218 serverWorld, class_1799 mainHand, class_2338 pos, class_2248 block, class_2680 state) {
        if (mainHand.method_7909() instanceof class_1794 && Simple_harvesting.CONFIG.HoeHarvestEnabled) {
            if (this.isCropBlock(world, pos) || this.isSpecialHarvestBlock(block)) {
                this.harvestAdjacentCrops(world, serverWorld, player, pos, block, state, true);
                if (Simple_harvesting.CONFIG.HoeUsesEnabled && !player.method_7337()) {
                    this.damageTool(mainHand, player);
                }
                return class_1269.field_5812;
            }
            if (this.isInBlockList(block)) {
                this.destroyGrassInRadius(world, player, pos, mainHand);
                return class_1269.field_5812;
            }
        } else if (mainHand.method_7960() && Simple_harvesting.CONFIG.HandHarvestEnabled && (this.isCropBlock(world, pos) || this.isSpecialHarvestBlock(block))) {
            this.harvestSingleCrop(world, serverWorld, player, pos, block, state, true);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private boolean isExcludedBlock(class_2248 block) {
        return block == class_2246.field_16999 || block == class_2246.field_28675 || block == class_2246.field_28676;
    }

    private boolean isInBlockList(class_2248 block) {
        for (class_2248 b : HARVESTABLE_BLOCKS) {
            if (b != block) continue;
            return true;
        }
        return false;
    }

    private boolean isCropBlock(class_1937 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        if (this.isExcludedBlock(block)) {
            return false;
        }
        if (block instanceof class_2302 || block instanceof class_2242) {
            return true;
        }
        if (block instanceof class_2282) {
            class_2282 cocoa = (class_2282)block;
            return (Integer)world.method_8320(pos).method_11654((class_2769)class_2282.field_10779) >= 2;
        }
        if (block instanceof class_2421) {
            return (Integer)world.method_8320(pos).method_11654((class_2769)class_2421.field_11306) >= 3;
        }
        return this.hasAgeProperty(block);
    }

    private boolean isSpecialHarvestBlock(class_2248 block) {
        if (this.isExcludedBlock(block)) {
            return false;
        }
        for (class_2248 b : SPECIAL_HARVEST_BLOCKS) {
            if (b != block) continue;
            return true;
        }
        return false;
    }

    private boolean hasAgeProperty(class_2248 block) {
        for (class_2769 prop : block.method_9595().method_11659()) {
            class_2758 intProp;
            if (!(prop instanceof class_2758) || !(intProp = (class_2758)prop).method_11899().equals("age")) continue;
            return true;
        }
        return false;
    }

    private void destroyCropsInRadius(class_1937 world, class_1657 player, class_2338 center) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.add(center);
        while (!queue.isEmpty()) {
            class_2338 pos = (class_2338)queue.poll();
            if (!visited.add(pos) || pos.method_19455((class_2382)center) > Simple_harvesting.CONFIG.CropHarvestRadius) continue;
            class_2680 state = world.method_8320(pos);
            class_2248 block = state.method_26204();
            if (!this.isCropBlock(world, pos) && !this.isSpecialHarvestBlock(block) || this.isExcludedBlock(block)) continue;
            world.method_8651(pos, true, (class_1297)player);
            queue.add(pos.method_10095());
            queue.add(pos.method_10072());
            queue.add(pos.method_10078());
            queue.add(pos.method_10067());
            queue.add(pos.method_10084());
            queue.add(pos.method_10074());
        }
    }

    private void destroyGrassInRadius(class_1937 world, class_1657 player, class_2338 center, class_1799 hoe) {
        int radius = Simple_harvesting.CONFIG.GrassRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos = center.method_10069(x, y, z);
                    class_2680 state = world.method_8320(pos);
                    class_2248 block = state.method_26204();
                    if (!this.isInBlockList(block)) continue;
                    world.method_8651(pos, true, (class_1297)player);
                    if (!Simple_harvesting.CONFIG.HoeUsesEnabled || !(hoe.method_7909() instanceof class_1794) || player.method_7337()) continue;
                    this.damageTool(hoe, player);
                }
            }
        }
    }

    private void harvestAdjacentCrops(class_1937 world, class_3218 serverWorld, class_1657 player, class_2338 pos, class_2248 block, class_2680 state, boolean replant) {
        int maxAge;
        class_2758 ageProp = this.getAgeProperty(state);
        if (ageProp == null && !this.isSpecialHarvestBlock(block) || this.isExcludedBlock(block)) {
            return;
        }
        int age = ageProp != null ? (Integer)state.method_11654((class_2769)ageProp) : 0;
        if (age < (maxAge = this.getMaxAge(block, state))) {
            return;
        }
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.add(pos);
        while (!queue.isEmpty()) {
            class_2758 currentAgeProp;
            class_2680 currentState;
            class_2248 currentBlock;
            class_2338 currentPos = (class_2338)queue.poll();
            if (!visited.add(currentPos) || currentPos.method_19455((class_2382)pos) > Simple_harvesting.CONFIG.CropHarvestRadius || this.isExcludedBlock(currentBlock = (currentState = world.method_8320(currentPos)).method_26204()) || (currentAgeProp = this.getAgeProperty(currentState)) == null && !this.isSpecialHarvestBlock(currentBlock)) continue;
            boolean readyToHarvest = false;
            if (currentBlock instanceof class_2282) {
                readyToHarvest = (Integer)currentState.method_11654((class_2769)class_2282.field_10779) >= 2;
            } else if (currentBlock instanceof class_2421) {
                readyToHarvest = (Integer)currentState.method_11654((class_2769)class_2421.field_11306) >= 3;
            } else if (currentAgeProp != null) {
                readyToHarvest = (Integer)currentState.method_11654((class_2769)currentAgeProp) >= this.getMaxAge(currentBlock, currentState);
            } else if (currentBlock == class_2246.field_10211 || currentBlock == class_2246.field_10424 || currentBlock == class_2246.field_9993) {
                readyToHarvest = true;
            }
            if (!readyToHarvest) continue;
            class_2248.method_9511((class_2680)currentState, (class_1937)serverWorld, (class_2338)currentPos, null, (class_1297)player, (class_1799)class_1799.field_8037);
            world.method_8651(currentPos, false, (class_1297)player);
            if (replant) {
                if (currentBlock instanceof class_2302 || currentBlock instanceof class_2242) {
                    world.method_8652(currentPos, currentBlock.method_9564(), 3);
                } else if (currentBlock instanceof class_2282) {
                    world.method_8652(currentPos, (class_2680)currentState.method_11657((class_2769)class_2282.field_10779, (Comparable)Integer.valueOf(0)), 3);
                } else if (currentBlock instanceof class_2421) {
                    world.method_8652(currentPos, (class_2680)currentBlock.method_9564().method_11657((class_2769)class_2421.field_11306, (Comparable)Integer.valueOf(0)), 3);
                }
            }
            queue.add(currentPos.method_10095());
            queue.add(currentPos.method_10072());
            queue.add(currentPos.method_10078());
            queue.add(currentPos.method_10067());
            queue.add(currentPos.method_10084());
            queue.add(currentPos.method_10074());
        }
    }

    private void harvestSingleCrop(class_1937 world, class_3218 serverWorld, class_1657 player, class_2338 pos, class_2248 block, class_2680 state, boolean replant) {
        if (this.isExcludedBlock(block)) {
            return;
        }
        class_2758 ageProp = this.getAgeProperty(state);
        int age = ageProp != null ? (Integer)state.method_11654((class_2769)ageProp) : 0;
        int maxAge = this.getMaxAge(block, state);
        boolean readyToHarvest = false;
        if (block instanceof class_2282) {
            readyToHarvest = (Integer)state.method_11654((class_2769)class_2282.field_10779) >= 2;
        } else if (block instanceof class_2421) {
            readyToHarvest = (Integer)state.method_11654((class_2769)class_2421.field_11306) >= 3;
        } else if (ageProp != null) {
            readyToHarvest = age >= maxAge;
        } else if (block == class_2246.field_10211 || block == class_2246.field_10424 || block == class_2246.field_9993) {
            readyToHarvest = true;
        }
        if (readyToHarvest) {
            class_2248.method_9511((class_2680)state, (class_1937)serverWorld, (class_2338)pos, null, (class_1297)player, (class_1799)class_1799.field_8037);
            world.method_8651(pos, false, (class_1297)player);
            if (replant) {
                if (block instanceof class_2302 || block instanceof class_2242) {
                    world.method_8652(pos, block.method_9564(), 3);
                } else if (block instanceof class_2282) {
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2282.field_10779, (Comparable)Integer.valueOf(0)), 3);
                } else if (block instanceof class_2421) {
                    world.method_8652(pos, (class_2680)block.method_9564().method_11657((class_2769)class_2421.field_11306, (Comparable)Integer.valueOf(0)), 3);
                }
            }
        }
    }

    private int getMaxAge(class_2248 block, class_2680 state) {
        if (block instanceof class_2302) {
            class_2302 crop = (class_2302)block;
            return crop.method_9827();
        }
        if (block instanceof class_2242) {
            class_2242 beet = (class_2242)block;
            return beet.method_9827();
        }
        if (block instanceof class_2282) {
            return 2;
        }
        if (block instanceof class_2421) {
            return 3;
        }
        return 0;
    }

    private class_2758 getAgeProperty(class_2680 state) {
        for (class_2769 prop : state.method_26204().method_9595().method_11659()) {
            class_2758 intProp;
            if (!(prop instanceof class_2758) || !(intProp = (class_2758)prop).method_11899().equals("age")) continue;
            return intProp;
        }
        return null;
    }

    private void damageTool(class_1799 stack, class_1657 player) {
        if (player.method_7337()) {
            return;
        }
        stack.method_7974(stack.method_7919() + 1);
        if (stack.method_7919() >= stack.method_7936()) {
            player.method_31548().method_7378(stack);
        }
    }

    static {
        HARVESTABLE_BLOCKS = new class_2248[]{class_2246.field_10214, class_2246.field_10479, class_2246.field_10182, class_2246.field_10449, class_2246.field_10086, class_2246.field_10226, class_2246.field_10573, class_2246.field_10270, class_2246.field_10048, class_2246.field_10156, class_2246.field_10315, class_2246.field_10554, class_2246.field_9995, class_2246.field_10548, class_2246.field_10428, class_2246.field_42734, class_2246.field_42749, class_2246.field_10003, class_2246.field_10583, class_2246.field_10430, class_2246.field_10376, class_2246.field_9993, class_2246.field_10238, class_2246.field_10112, class_2246.field_42750, class_2246.field_22125, class_2246.field_22116, class_2246.field_22117, class_2246.field_46286, class_2246.field_46287, class_2246.field_10463, class_2246.field_10313, class_2246.field_10378, class_2246.field_43229, class_2246.field_28684, class_2246.field_28682, class_2246.field_28683, class_2246.field_10476, class_2246.field_10559, class_2246.field_10251, class_2246.field_22121, class_2246.field_22114, class_2246.field_10588, class_2246.field_10606, class_2246.field_28686, class_2246.field_28675, class_2246.field_54733, class_2246.field_10597, class_2246.field_22123, class_2246.field_22124, class_2246.field_23078, class_2246.field_23079, class_2246.field_28677, class_2246.field_28411};
        SPECIAL_HARVEST_BLOCKS = new class_2248[]{class_2246.field_10424, class_2246.field_10211, class_2246.field_9993, class_2246.field_10302, class_2246.field_9974};
    }
}

