/*
 * Decompiled with CFR 0.152.
 */
package comToi.simple_harvesting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class SHConfig {
    public int cropHarvestRadius = 3;
    public int grassRadius = 3;
    public boolean hoeUsesEnabled = true;
    public boolean handHarvestEnabled = true;
    private final transient File file;

    public SHConfig(File configFile) {
        this.file = configFile;
        if (!this.file.exists()) {
            this.save();
        } else {
            this.load();
        }
    }

    public void load() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.file));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("\"cropHarvestRadius\"")) {
                    this.cropHarvestRadius = this.parseInt(line, this.cropHarvestRadius);
                    continue;
                }
                if (line.startsWith("\"grassRadius\"")) {
                    this.grassRadius = this.parseInt(line, this.grassRadius);
                    continue;
                }
                if (line.startsWith("\"hoeUsesEnabled\"")) {
                    this.hoeUsesEnabled = this.parseBoolean(line, this.hoeUsesEnabled);
                    continue;
                }
                if (!line.startsWith("\"handHarvestEnabled\"")) continue;
                this.handHarvestEnabled = this.parseBoolean(line, this.handHarvestEnabled);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int parseInt(String line, int defaultValue) {
        try {
            String value = line.split(":")[1].split("\\(")[0].trim().replace(",", "");
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private boolean parseBoolean(String line, boolean defaultValue) {
        try {
            String value = line.split(":")[1].split("\\(")[0].trim().replace(",", "");
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void save() {
        try {
            if (!this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            String content = "{\n  \"cropHarvestRadius\": " + this.cropHarvestRadius + " (standard: 3),\n  \"grassRadius\": " + this.grassRadius + " (standard: 3),\n  \"hoeUsesEnabled\": " + this.hoeUsesEnabled + " (standard: true),\n  \"handHarvestEnabled\": " + this.handHarvestEnabled + " (standard: true)\n}";
            try (FileWriter writer = new FileWriter(this.file);){
                writer.write(content);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

